/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;

public class Optimizer {
    public static final int NO_OPTIMIZATION = 0;
    public static final int FULL_OPTIMIZATION = 10;
    protected Configuration config;
    private int optimizationLevel = 10;
    private boolean tracing;

    public Optimizer(Configuration config) {
        this.config = config;
        this.tracing = config.getBooleanProperty("http://saxon.sf.net/feature/trace-optimizer-decisions");
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setOptimizationLevel(int level) {
        if (level < 0 || level > 10) {
            throw new IllegalArgumentException("Optimization level");
        }
        this.optimizationLevel = level;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public Expression optimizeGeneralComparison(ExpressionVisitor visitor, GeneralComparison gc, boolean backwardsCompatible, ContextItemStaticInfo contextItemType) {
        return gc;
    }

    public Expression optimizeCopy(ExpressionVisitor visitor, ContextItemStaticInfo cisi, Expression select) throws XPathException {
        if (select.getItemType().isPlainType()) {
            return select;
        }
        return null;
    }

    public Expression convertPathExpressionToKey(SlashExpression pathExp, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression tryIndexedFilter(FilterExpression f, ExpressionVisitor visitor, boolean indexFirstOperand, boolean contextIsDoc) {
        return f;
    }

    public FilterExpression convertToFilterExpression(SlashExpression pathExp, TypeHierarchy th) throws XPathException {
        return null;
    }

    public int isIndexableFilter(Expression filter) {
        return 0;
    }

    public Sequence makeIndexedValue(SequenceIterator iter) throws XPathException {
        throw new UnsupportedOperationException("Indexing requires Saxon-EE");
    }

    public boolean isVariableReplaceableByDot(Expression exp, Binding[] binding) {
        if (exp instanceof ContextSwitchingExpression) {
            Expression start = ((ContextSwitchingExpression)((Object)exp)).getSelectExpression();
            Expression step = ((ContextSwitchingExpression)((Object)exp)).getActionExpression();
            return this.isVariableReplaceableByDot(start, binding) && !ExpressionTool.dependsOnVariable(step, binding);
        }
        for (Operand o : exp.operands()) {
            if (this.isVariableReplaceableByDot(o.getChildExpression(), binding)) continue;
            return false;
        }
        return true;
    }

    public Expression makeConditionalDocumentSorter(DocumentSorter sorter, SlashExpression path) throws XPathException {
        return sorter;
    }

    public Expression tryInlineFunctionCall(UserFunctionCall functionCall, ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) {
        return functionCall;
    }

    public Expression promoteExpressionsToGlobal(Expression body, GlobalVariableManager gvManager, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression trySwitch(Choose choose) {
        return choose;
    }

    public Expression tryGeneralComparison(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType, OrExpression orExpr) throws XPathException {
        return orExpr;
    }

    public Expression extractGlobalVariables(Expression body, ExpressionVisitor visitor, PromotionOffer offer) throws XPathException {
        return null;
    }

    public RuleTarget makeInversion(Pattern pattern, NamedTemplate template) throws XPathException {
        return null;
    }

    public void makeCopyOperationsExplicit(Expression parent, Operand child) throws XPathException {
    }

    public void checkStreamability(XSLTemplate sourceTemplate, TemplateRule compiledTemplate) throws XPathException {
    }

    public Expression optimizeQuantifiedExpressionForStreaming(QuantifiedExpression expr) throws XPathException {
        return expr;
    }

    public Expression generateMultithreadedInstruction(Expression instruction) {
        return instruction;
    }

    public Expression compileToByteCode(Expression expr, String objectName, int evaluationMethods) {
        return null;
    }

    public void trace(String message, Expression exp) {
        if (this.tracing) {
            Logger err = this.getConfiguration().getLogger();
            err.info("OPT ======================================");
            err.info("OPT : At line " + exp.getLocation().getLineNumber() + " of " + exp.getSystemId());
            err.info("OPT : " + message);
            err.info("OPT ====== Expression after rewrite ======");
            exp.explain(err);
            err.info("\nOPT ======================================");
        }
    }

    public void trace(String message) {
        if (this.tracing) {
            Logger err = this.getConfiguration().getLogger();
            err.info("OPT ======================================");
            err.info("OPT : " + message);
            err.info("OPT ======================================");
        }
    }
}

