/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;

public class SaxonOutputKeys {
    public static final String SAXON_XQUERY_METHOD = "{http://saxon.sf.net/}xquery";
    public static final String SAXON_BASE64_BINARY_METHOD = "{http://saxon.sf.net/}base64Binary";
    public static final String SAXON_HEX_BINARY_METHOD = "{http://saxon.sf.net/}hexBinary";
    public static final String SAXON_PTREE_METHOD = "{http://saxon.sf.net/}ptree";
    public static final String ALLOW_DUPLICATE_NAMES = "allow-duplicate-names";
    public static final String BUILD_TREE = "build-tree";
    public static final String INDENT_SPACES = "{http://saxon.sf.net/}indent-spaces";
    public static final String LINE_LENGTH = "{http://saxon.sf.net/}line-length";
    public static final String SUPPRESS_INDENTATION = "suppress-indentation";
    public static final String HTML_VERSION = "html-version";
    public static final String ITEM_SEPARATOR = "item-separator";
    public static final String JSON_NODE_OUTPUT_METHOD = "json-node-output-method";
    public static final String ATTRIBUTE_ORDER = "{http://saxon.sf.net/}attribute-order";
    public static final String DOUBLE_SPACE = "{http://saxon.sf.net/}double-space";
    public static final String NEWLINE = "{http://saxon.sf.net/}newline";
    public static final String STYLESHEET_VERSION = "{http://saxon.sf.net/}stylesheet-version";
    public static final String USE_CHARACTER_MAPS = "use-character-maps";
    public static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    public static final String UNDECLARE_PREFIXES = "undeclare-prefixes";
    public static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    public static final String CHARACTER_REPRESENTATION = "{http://saxon.sf.net/}character-representation";
    public static final String NEXT_IN_CHAIN = "{http://saxon.sf.net/}next-in-chain";
    public static final String NEXT_IN_CHAIN_BASE_URI = "{http://saxon.sf.net/}next-in-chain-base-uri";
    public static final String BYTE_ORDER_MARK = "byte-order-mark";
    public static final String NORMALIZATION_FORM = "normalization-form";
    public static final String RECOGNIZE_BINARY = "{http://saxon.sf.net/}recognize-binary";
    public static final String REQUIRE_WELL_FORMED = "{http://saxon.sf.net/}require-well-formed";
    public static final String SUPPLY_SOURCE_LOCATOR = "{http://saxon.sf.net/}supply-source-locator";
    public static final String WRAP = "{http://saxon.sf.net/}wrap-result-sequence";
    public static final String IMPLICIT_RESULT_DOCUMENT = "{http://saxon.sf.net/}implicit-result-document";
    public static final String UNFAILING = "{http://saxon.sf.net/}unfailing";
    private static Pattern publicIdPattern = Pattern.compile("^[\\s\\r\\na-zA-Z0-9\\-'()+,./:=?;!*#@$_%]*$");

    private SaxonOutputKeys() {
    }

    public static String checkOutputProperty(String key, String value, Configuration config, boolean allow30) throws XPathException {
        if (!key.startsWith("{") || key.startsWith("{http://saxon.sf.net/}")) {
            if (key.equals(ALLOW_DUPLICATE_NAMES)) {
                if (value != null) {
                    value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                }
            } else if (key.equals(BUILD_TREE)) {
                if (value != null) {
                    value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                }
            } else if (key.equals(BYTE_ORDER_MARK)) {
                if (value != null) {
                    value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                }
            } else if (key.equals("cdata-section-elements")) {
                if (value != null) {
                    SaxonOutputKeys.checkListOfClarkNames(key, value);
                }
            } else if (key.equals("doctype-public")) {
                if (value != null) {
                    SaxonOutputKeys.checkPublicIdentifier(value);
                }
            } else if (key.equals("doctype-system")) {
                if (value != null) {
                    SaxonOutputKeys.checkSystemIdentifier(value);
                }
            } else if (!key.equals("encoding")) {
                if (key.equals(ESCAPE_URI_ATTRIBUTES)) {
                    if (value != null) {
                        value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                    }
                } else if (key.equals(INCLUDE_CONTENT_TYPE)) {
                    if (value != null) {
                        value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                    }
                } else if (key.equals("indent")) {
                    if (value != null) {
                        value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                    }
                } else if (!key.equals("media-type")) {
                    if (key.equals("method") || key.equals(JSON_NODE_OUTPUT_METHOD)) {
                        if (value != null) {
                            SaxonOutputKeys.checkMethod(key, value, allow30, config);
                        }
                    } else if (!key.equals(NEWLINE)) {
                        if (key.equals(NORMALIZATION_FORM)) {
                            if (value != null) {
                                SaxonOutputKeys.checkNormalizationForm(value);
                            }
                        } else if (key.equals("omit-xml-declaration")) {
                            if (value != null) {
                                value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                            }
                        } else if (key.equals("standalone")) {
                            if (value != null && !value.equals("omit")) {
                                value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                            }
                        } else if (key.equals(UNDECLARE_PREFIXES)) {
                            if (value != null) {
                                value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                            }
                        } else if (key.equals(USE_CHARACTER_MAPS)) {
                            if (value != null) {
                                SaxonOutputKeys.checkListOfClarkNames(key, value);
                            }
                        } else if (!key.equals("version") && !key.equals(STYLESHEET_VERSION)) {
                            if (key.equals(INDENT_SPACES)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkExtensions(key, config);
                                    SaxonOutputKeys.checkNonNegativeInteger(key, value);
                                }
                            } else if (key.equals(LINE_LENGTH)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkExtensions(key, config);
                                    SaxonOutputKeys.checkNonNegativeInteger(key, value);
                                }
                            } else if (key.equals(CHARACTER_REPRESENTATION)) {
                                SaxonOutputKeys.checkExtensions(key, config);
                            } else if (key.equals(NEXT_IN_CHAIN)) {
                                SaxonOutputKeys.checkExtensions(key, config);
                            } else if (!key.equals(NEXT_IN_CHAIN_BASE_URI)) {
                                if (key.equals(REQUIRE_WELL_FORMED)) {
                                    if (value != null) {
                                        value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                                    }
                                } else if (key.equals(RECOGNIZE_BINARY)) {
                                    if (value != null) {
                                        SaxonOutputKeys.checkExtensions(key, config);
                                        value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                                    }
                                } else if (key.equals(SUPPRESS_INDENTATION)) {
                                    if (value != null) {
                                        SaxonOutputKeys.checkExtensions(key, config);
                                        SaxonOutputKeys.checkListOfClarkNames(key, value);
                                    }
                                } else if (key.equals(DOUBLE_SPACE)) {
                                    if (value != null) {
                                        SaxonOutputKeys.checkExtensions(key, config);
                                        SaxonOutputKeys.checkListOfClarkNames(key, value);
                                    }
                                } else if (key.equals(WRAP)) {
                                    if (value != null) {
                                        SaxonOutputKeys.checkExtensions(key, config);
                                        value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                                    }
                                } else if (key.equals(SUPPLY_SOURCE_LOCATOR)) {
                                    if (value != null) {
                                        value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                                    }
                                } else if (key.equals(HTML_VERSION)) {
                                    if (value != null) {
                                        SaxonOutputKeys.checkDecimal(key, value);
                                    }
                                } else if (key.equals(UNFAILING)) {
                                    if (value != null) {
                                        value = SaxonOutputKeys.checkYesOrNo(key, value, allow30);
                                    }
                                } else if (!key.equals(ITEM_SEPARATOR)) {
                                    throw new XPathException("Unknown serialization parameter " + Err.wrap(key), "XQST0109");
                                }
                            }
                        }
                    }
                }
            }
        }
        return value;
    }

    private static void checkExtensions(String key, Configuration config) throws XPathException {
        if (config != null) {
            config.checkLicensedFeature(8, "custom serialization " + key, -1);
        }
    }

    private static String checkYesOrNo(String key, String value, boolean allow30) throws XPathException {
        if (allow30) {
            if ("yes".equals(value) || "true".equals(value) || "1".equals(value)) {
                return "yes";
            }
            if ("no".equals(value) || "false".equals(value) || "0".equals(value)) {
                return "no";
            }
            throw new XPathException("Serialization parameter " + Err.wrap(key) + " must have the value yes|no, true|false, or 1|0", "SEPM0016");
        }
        if ("yes".equals(value) || "no".equals(value)) {
            return value;
        }
        throw new XPathException("Serialization parameter " + Err.wrap(key) + " must have the value yes or no", "SEPM0016");
    }

    private static void checkMethod(String key, String value, boolean allow30, Configuration config) throws XPathException {
        if (!("xml".equals(value) || "html".equals(value) || "xhtml".equals(value) || "text".equals(value))) {
            if (allow30 && !JSON_NODE_OUTPUT_METHOD.equals(key) && ("json".equals(value) || "adaptive".equals(value))) {
                return;
            }
            if (SaxonOutputKeys.isValidClarkName(value)) {
                SaxonOutputKeys.checkExtensions(value, config);
            } else {
                throw new XPathException("Invalid value for serialization method: must be xml, html, xhtml, text, or a QName in '{uri}local' form", "SEPM0016");
            }
        }
    }

    private static void checkNormalizationForm(String value) throws XPathException {
        if (!NameChecker.isValidNmtoken(value)) {
            throw new XPathException("Invalid value for normalization-form: must be NFC, NFD, NFKC, NFKD, fully-normalized, or none", "SEPM0016");
        }
    }

    private static boolean isValidClarkName(String value) {
        if (value.isEmpty() || value.charAt(0) != '{') {
            return false;
        }
        int closer = value.indexOf(125);
        return closer >= 1 && closer != value.length() - 1 && NameChecker.isValidNCName(value.substring(closer + 1));
    }

    private static void checkNonNegativeInteger(String key, String value) throws XPathException {
        try {
            int n = Integer.parseInt(value);
            if (n < 0) {
                throw new XPathException("Value of " + Err.wrap(key) + " must be a non-negative integer", "SEPM0016");
            }
        }
        catch (NumberFormatException err) {
            throw new XPathException("Value of " + Err.wrap(key) + " must be a non-negative integer", "SEPM0016");
        }
    }

    private static void checkDecimal(String key, String value) throws XPathException {
        if (!DecimalValue.castableAsDecimal(value)) {
            throw new XPathException("Value of " + Err.wrap(key) + " must be a decimal number", "SEPM0016");
        }
    }

    private static void checkListOfClarkNames(String key, String value) throws XPathException {
        StringTokenizer tok = new StringTokenizer(value, " \t\n\r", false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (SaxonOutputKeys.isValidClarkName(s) || NameChecker.isValidNCName(s)) continue;
            throw new XPathException("Value of " + Err.wrap(key) + " must be a list of QNames in '{uri}local' notation", "SEPM0016");
        }
    }

    private static void checkPublicIdentifier(String value) throws XPathException {
        if (!publicIdPattern.matcher(value).matches()) {
            throw new XPathException("Invalid character in doctype-public parameter", "SEPM0016");
        }
    }

    private static void checkSystemIdentifier(String value) throws XPathException {
        if (value.contains("'") && value.contains("\"")) {
            throw new XPathException("The doctype-system parameter must not contain both an apostrophe and a quotation mark", "SEPM0016");
        }
    }

    public static String parseListOfNodeNames(String value, NamespaceResolver nsResolver, boolean useDefaultNS, boolean prevalidated, String errorCode) throws XPathException {
        String s = "";
        StringTokenizer st = new StringTokenizer(value, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            String displayname = st.nextToken();
            if (prevalidated || nsResolver == null) {
                s = s + ' ' + displayname;
                continue;
            }
            if (displayname.startsWith("Q{")) {
                s = s + ' ' + displayname.substring(1);
                continue;
            }
            try {
                String[] parts = NameChecker.getQNameParts(displayname);
                String muri = nsResolver.getURIForPrefix(parts[0], useDefaultNS);
                if (muri == null) {
                    throw new XPathException("Namespace prefix '" + parts[0] + "' has not been declared", errorCode);
                }
                s = s + " {" + muri + '}' + parts[1];
            }
            catch (QNameException err) {
                throw new XPathException("Invalid element name. " + err.getMessage(), errorCode);
            }
        }
        return s;
    }

    public static boolean isXhtmlHtmlVersion5(Properties properties) {
        String htmlVersion = properties.getProperty(HTML_VERSION);
        try {
            return htmlVersion != null && ((DecimalValue)DecimalValue.makeDecimalValue(htmlVersion, false).asAtomic()).getDecimalValue().equals(BigDecimal.valueOf(5L));
        }
        catch (ValidationException e) {
            return false;
        }
    }

    public static boolean isHtmlVersion5(Properties properties) {
        String htmlVersion = properties.getProperty(HTML_VERSION);
        if (htmlVersion == null) {
            htmlVersion = properties.getProperty("version");
        }
        if (htmlVersion != null) {
            try {
                return ((DecimalValue)DecimalValue.makeDecimalValue(htmlVersion, false).asAtomic()).getDecimalValue().equals(BigDecimal.valueOf(5L));
            }
            catch (ValidationException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isBuildTree(Properties properties) {
        String buildTreeProperty = properties.getProperty(BUILD_TREE);
        if (buildTreeProperty != null) {
            return "yes".equals(buildTreeProperty);
        }
        String method = properties.getProperty("method");
        return !"json".equals(method) && !"adaptive".equals(method);
    }
}

