/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class NamePoolConverter
extends ProxyReceiver {
    NamePool oldPool;
    NamePool newPool;

    public NamePoolConverter(Receiver next, NamePool oldPool, NamePool newPool) {
        super(next);
        this.oldPool = oldPool;
        this.newPool = newPool;
    }

    public void setUnderlyingReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        int nc = this.newPool.allocate(nameCode.getPrefix(), nameCode.getURI(), nameCode.getLocalPart());
        this.nextReceiver.startElement(new CodedName(nc, this.newPool), typeCode, location, properties);
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        this.nextReceiver.namespace(namespaceBinding, properties);
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        int nc = this.newPool.allocate(nameCode.getPrefix(), nameCode.getURI(), nameCode.getLocalPart());
        this.nextReceiver.attribute(new CodedName(nc, this.newPool), typeCode, value, locationId, properties);
    }
}

