/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;

public class CurrentGroupingKeyCall
extends Expression
implements Callable {
    protected int computeCardinality() {
        return 57344;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("currentGroupingKey");
        out.endElement();
    }

    public Expression copy(RebindingMap rebindings) {
        return new CurrentGroupingKeyCall();
    }

    public int getIntrinsicDependencies() {
        return 32;
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        GroupIterator gi = c.getCurrentGroupIterator();
        if (gi == null || !gi.hasCurrentGroupingKey()) {
            if (this.getRetainedStaticContext().getXPathVersion() >= 30) {
                XPathException err = new XPathException("There is no current grouping key", "XTDE1071");
                err.setLocation(this.getLocation());
                throw err;
            }
            return EmptyIterator.emptyIterator();
        }
        return gi.getCurrentGroupingKey().iterate();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(this.iterate(context));
    }
}

