/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class UnparsedTextResource
implements Resource {
    private Configuration config;
    private String href = null;
    private String encoding = null;
    private String unparsedText = null;
    private InputStream inputStream;
    private String contentType = null;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        public Resource makeResource(Configuration config, String resourceURI, String contentType, AbstractResourceCollection.InputDetails details) throws XPathException {
            return new UnparsedTextResource(config, resourceURI, details.inputStream);
        }
    };

    public UnparsedTextResource(Configuration config, String href, InputStream in) {
        this.config = config;
        this.href = href;
        this.inputStream = in;
    }

    public String getResourceURI() {
        return this.href;
    }

    public Item getItem(XPathContext context) throws XPathException {
        if (this.unparsedText == null) {
            StringBuilder builder = null;
            try {
                builder = CatalogCollection.makeStringBuilderFromStream(this.inputStream);
            }
            catch (FileNotFoundException e) {
                throw new XPathException(e);
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
            this.unparsedText = builder.toString();
        }
        return new StringValue(this.unparsedText);
    }

    public String getContentType() {
        return this.contentType;
    }
}

