/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class XdmFunctionItem
extends XdmItem {
    protected XdmFunctionItem(Function fi) {
        super(fi);
    }

    public QName getName() {
        Function fi = (Function)this.getUnderlyingValue();
        StructuredQName sq = fi.getFunctionName();
        return sq == null ? null : new QName(sq);
    }

    public int getArity() {
        Function fi = (Function)this.getUnderlyingValue();
        return fi.getArity();
    }

    public boolean isAtomicValue() {
        return false;
    }

    public XdmValue call(Processor processor, XdmValue ... arguments) throws SaxonApiException {
        if (arguments.length != this.getArity()) {
            throw new SaxonApiException("Supplied " + arguments.length + " arguments, required " + this.getArity());
        }
        try {
            Function fi = (Function)this.getUnderlyingValue();
            Sequence[] argVals = new Sequence[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                argVals[i] = arguments[i].getUnderlyingValue();
            }
            XPathContext context = processor.getUnderlyingConfiguration().getConversionContext();
            Sequence result = fi.call(context, argVals);
            GroundedValue se = SequenceExtent.makeSequenceExtent(result.iterate());
            return XdmValue.wrap(se);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }
}

