/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.s9api.ConstructedItemType;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.WhitespaceStrippingPolicy;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltExecutable {
    Processor processor;
    PreparedStylesheet preparedStylesheet;

    protected XsltExecutable(Processor processor, PreparedStylesheet preparedStylesheet) {
        this.processor = processor;
        this.preparedStylesheet = preparedStylesheet;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public XsltTransformer load() {
        return new XsltTransformer(this.processor, this.preparedStylesheet.newController(), this.preparedStylesheet.getCompileTimeParams());
    }

    public Xslt30Transformer load30() {
        return new Xslt30Transformer(this.processor, this.preparedStylesheet.newController(), this.preparedStylesheet.getCompileTimeParams());
    }

    public void explain(Destination destination) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        try {
            this.preparedStylesheet.explain(new ExpressionPresenter(config, destination.getReceiver(config)));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public void export(OutputStream destination) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        ExpressionPresenter presenter = new ExpressionPresenter(config, new StreamResult(destination), true);
        if (this.preparedStylesheet.getTopLevelPackage().getTargetEdition().equals("JS")) {
            presenter.setOption("target", "JS");
        }
        try {
            ((StylesheetPackage)this.preparedStylesheet.getTopLevelPackage()).export(presenter);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        try {
            destination.close();
        }
        catch (IOException e) {
            throw new SaxonApiException(e);
        }
    }

    public void export(OutputStream destination, String target) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        ExpressionPresenter presenter = new ExpressionPresenter(config, new StreamResult(destination), true);
        presenter.setOption("target", target);
        try {
            ((StylesheetPackage)this.preparedStylesheet.getTopLevelPackage()).export(presenter);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        try {
            destination.close();
        }
        catch (IOException e) {
            throw new SaxonApiException(e);
        }
    }

    public WhitespaceStrippingPolicy getWhitespaceStrippingPolicy() {
        return new WhitespaceStrippingPolicy(this.preparedStylesheet);
    }

    public HashMap<QName, ParameterDetails> getGlobalParameters() {
        Iterable<GlobalParam> globals = this.preparedStylesheet.getGlobalParameters();
        if (globals == null) {
            return new HashMap<QName, ParameterDetails>(1);
        }
        HashMap<QName, ParameterDetails> params = new HashMap<QName, ParameterDetails>();
        for (GlobalParam v : globals) {
            ParameterDetails details = new ParameterDetails(v.getRequiredType(), v.isRequiredParam());
            params.put(new QName(v.getVariableQName()), details);
        }
        return params;
    }

    public PreparedStylesheet getUnderlyingCompiledStylesheet() {
        return this.preparedStylesheet;
    }

    public class ParameterDetails {
        private SequenceType type;
        private boolean isRequired;

        protected ParameterDetails(SequenceType type, boolean isRequired) {
            this.type = type;
            this.isRequired = isRequired;
        }

        public ItemType getDeclaredItemType() {
            return new ConstructedItemType(this.type.getPrimaryType(), XsltExecutable.this.processor);
        }

        public OccurrenceIndicator getDeclaredCardinality() {
            return OccurrenceIndicator.getOccurrenceIndicator(this.type.getCardinality());
        }

        public SequenceType getUnderlyingDeclaredType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.isRequired;
        }
    }
}

