/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.PackageVersionRanges;
import net.sf.saxon.style.StylesheetPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageLibrary {
    Map<String, List<StylesheetPackage>> packageMap = new HashMap<String, List<StylesheetPackage>>();

    public void addPackage(StylesheetPackage packageIn) {
        this.addPackage(packageIn.getPackageName(), packageIn);
    }

    public void addPackage(String name, StylesheetPackage packageIn) {
        List<StylesheetPackage> list = this.packageMap.get(name);
        if (list == null) {
            list = new ArrayList<StylesheetPackage>();
            list.add(packageIn);
            this.packageMap.put(name, list);
        } else {
            for (StylesheetPackage p : list) {
                if (!p.getPackageVersion().equals(packageIn.getPackageVersion())) continue;
                list.remove(p);
                list.add(packageIn);
                return;
            }
            list.add(packageIn);
        }
    }

    public StylesheetPackage getPackage(String name, PackageVersionRanges ranges) {
        return this.getPackage(name, ranges, true);
    }

    public StylesheetPackage getPackage(String name, PackageVersionRanges ranges, boolean first) {
        PackageVersion latestVersion = null;
        StylesheetPackage latestPackage = null;
        List<StylesheetPackage> list = this.packageMap.get(name);
        if (list == null) {
            return null;
        }
        for (StylesheetPackage p : list) {
            PackageVersion pv = p.getPackageVersion();
            if (!ranges.contains(pv)) continue;
            if (first) {
                return p;
            }
            if (latestVersion != null && latestVersion.compareTo(pv) != -1) continue;
            latestVersion = pv;
            latestPackage = p;
        }
        return latestPackage;
    }

    public StylesheetPackage getPackage(String name) {
        PackageVersion latestVersion = null;
        StylesheetPackage latestPackage = null;
        List<StylesheetPackage> list = this.packageMap.get(name);
        if (list == null) {
            return null;
        }
        for (StylesheetPackage p : list) {
            if (latestVersion != null && latestVersion.compareTo(p.getPackageVersion()) != -1) continue;
            latestVersion = p.getPackageVersion();
            latestPackage = p;
        }
        return latestPackage;
    }

    public int size(String name) {
        return this.packageMap.get(name).size();
    }

    public List<StylesheetPackage> getPackages() {
        ArrayList<StylesheetPackage> result = new ArrayList<StylesheetPackage>();
        for (String n : this.packageMap.keySet()) {
            result.addAll((Collection<StylesheetPackage>)this.packageMap.get(n));
        }
        return result;
    }

    public PackageLibrary copy() {
        PackageLibrary p = new PackageLibrary();
        p.packageMap.putAll(this.packageMap);
        return p;
    }
}

