/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.File;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.ElementAvailable;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.style.XSLGeneralIncorporate;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.UsePack;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NestedIntegerValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack<String> defaultNamespaceStack = new Stack();
    private Stack<Integer> versionStack = new Stack();
    private DateTimeValue currentDateTime = DateTimeValue.getCurrentDateTime(null);
    private Compilation compilation;
    private Stack<String> systemIdStack = new Stack();
    private Stack<URI> baseUriStack = new Stack();
    private NestedIntegerValue precedence;
    private int importCount = 0;
    private boolean dropUnderscoredAttributes;
    private DocumentImpl includedDoc = null;

    public UseWhenFilter(Compilation compilation, Receiver next, NestedIntegerValue precedence) {
        super(next);
        this.compilation = compilation;
        this.precedence = precedence;
        assert (next instanceof LinkedTreeBuilder);
    }

    public void setStartTagBuffer(StartTagBuffer startTag) {
        this.startTag = startTag;
    }

    @Override
    public void open() throws XPathException {
        this.nextReceiver.open();
        String sysId = this.getSystemId();
        if (sysId == null) {
            sysId = "";
        }
        this.systemIdStack.push(sysId);
        try {
            this.baseUriStack.push(new URI(sysId));
        }
        catch (URISyntaxException e) {
            try {
                this.baseUriStack.push(new File(sysId).toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.includedDoc = null;
        boolean inXsltNamespace = elemName.hasURI("http://www.w3.org/1999/XSL/Transform");
        String stdAttUri = inXsltNamespace ? "" : "http://www.w3.org/1999/XSL/Transform";
        this.defaultNamespaceStack.push(this.startTag.getAttribute(stdAttUri, "xpath-default-namespace"));
        if (this.emptyStylesheetElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            boolean isStylesheetElement;
            String versionAtt;
            URI baseUri = this.processBaseUri(location);
            boolean ignore = false;
            int fp = -1;
            if (inXsltNamespace) {
                fp = elemName.obtainFingerprint(this.getNamePool());
            }
            int version = Integer.MIN_VALUE;
            if (inXsltNamespace) {
                if (fp != 185) {
                    versionAtt = this.startTag.getAttribute("", "version");
                    version = this.processVersionAttribute(versionAtt);
                }
            } else {
                versionAtt = this.startTag.getAttribute("http://www.w3.org/1999/XSL/Transform", "version");
                version = this.processVersionAttribute(versionAtt);
            }
            if (version == Integer.MIN_VALUE) {
                version = this.versionStack.isEmpty() ? 30 : this.versionStack.peek();
            }
            this.versionStack.push(version);
            if (inXsltNamespace && this.defaultNamespaceStack.size() == 2 && version > 30 && !ElementAvailable.isXslt30Element(fp)) {
                ignore = true;
            }
            if (inXsltNamespace && !ignore) {
                this.processShadowAttributes(elemName, location, baseUri);
            }
            boolean bl = isStylesheetElement = inXsltNamespace && (elemName.getLocalPart().equals("stylesheet") || elemName.getLocalPart().equals("transform") || elemName.getLocalPart().equals("package"));
            if (!ignore) {
                String useWhen = this.startTag.getAttribute(stdAttUri, "use-when");
                if (useWhen != null) {
                    AttributeCollection allAtts = this.startTag.getAllAttributes();
                    NodeName attName = allAtts.getNodeName(allAtts.getIndex(stdAttUri, "use-when"));
                    AttributeLocation attLoc = new AttributeLocation(elemName.getStructuredQName(), attName.getStructuredQName(), location);
                    boolean use = this.evaluateUseWhen(useWhen, attLoc, baseUri.toString());
                    boolean bl2 = ignore = !use;
                }
                if (ignore) {
                    if (isStylesheetElement) {
                        this.emptyStylesheetElement = true;
                    } else {
                        this.depthOfHole = 1;
                        return;
                    }
                }
            }
            if (inXsltNamespace) {
                boolean isVariable = elemName.getLocalPart().equals("variable");
                boolean isParam = elemName.getLocalPart().equals("param");
                String staticStr = Whitespace.trim(this.startTag.getAttribute("", "static"));
                if ((isVariable || isParam) && this.defaultNamespaceStack.size() == 2 && StyleElement.isYes(staticStr)) {
                    this.processStaticVariable(elemName, location, baseUri, this.precedence);
                }
                boolean isInclude = elemName.getLocalPart().equals("include");
                boolean isImport = elemName.getLocalPart().equals("import");
                if ((isInclude || isImport) && this.defaultNamespaceStack.size() == 2) {
                    this.includedDoc = this.processIncludeImport(elemName, location, baseUri, isImport);
                }
                if (elemName.getLocalPart().equals("import-schema") && this.defaultNamespaceStack.size() == 2) {
                    this.compilation.setSchemaAware(true);
                }
                if (elemName.getLocalPart().equals("use-package") && this.defaultNamespaceStack.size() == 2) {
                    if (this.precedence.getDepth() > 1) {
                        throw new XPathException("xsl:use-package cannot appear in an imported stylesheet", "XTSE3008");
                    }
                    AttributeCollection atts = this.startTag.getAllAttributes();
                    String name = atts.getValue("", "name");
                    String pversion = atts.getValue("", "package-version");
                    if (name != null) {
                        try {
                            UsePack use = new UsePack(name, pversion, location.saveLocation());
                            this.compilation.registerPackageDependency(use);
                        }
                        catch (XPathException xPathException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.dropUnderscoredAttributes = inXsltNamespace;
            this.nextReceiver.startElement(elemName, typeCode, location, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    private DocumentImpl processIncludeImport(NodeName elemName, Location location, URI baseUri, boolean isImport) throws XPathException {
        Source source;
        String href = Whitespace.trim(this.startTag.getAttribute("", "href"));
        if (href == null) {
            throw new XPathException("Missing href attribute on " + elemName.getDisplayName(), "XTSE0010");
        }
        URIResolver resolver = this.compilation.getCompilerInfo().getURIResolver();
        String baseUriStr = baseUri.toString();
        DocumentURI key = DocumentFn.computeDocumentKey(href, baseUriStr, this.compilation.getPackageData(), resolver, false);
        Map<DocumentURI, TreeInfo> map = this.compilation.getStylesheetModules();
        if (map.containsKey(key)) {
            return (DocumentImpl)map.get(key);
        }
        try {
            source = resolver.resolve(href, baseUriStr);
        }
        catch (TransformerException e) {
            throw XPathException.makeXPathException(e);
        }
        if (source == null) {
            source = this.getConfiguration().getSystemURIResolver().resolve(href, baseUriStr);
        }
        NestedIntegerValue newPrecedence = this.precedence;
        if (isImport) {
            newPrecedence = this.precedence.getStem().append(this.precedence.getLeaf() - 1).append(2 * ++this.importCount);
        }
        try {
            DocumentImpl includedDoc = StylesheetModule.loadStylesheetModule(source, false, this.compilation, newPrecedence);
            map.put(key, includedDoc);
            return includedDoc;
        }
        catch (XPathException e) {
            e.setLocation(location);
            e.maybeSetErrorCode("XTSE0165");
            if ("XTSE0180".equals(e.getErrorCodeLocalPart()) && isImport) {
                e.setErrorCode("XTSE0210");
            }
            if (!e.hasBeenReported()) {
                this.compilation.reportError(e);
            }
            throw e;
        }
    }

    private void processStaticVariable(NodeName elemName, Location location, URI baseUri, NestedIntegerValue precedence) throws XPathException {
        StructuredQName varName;
        String nameStr = this.startTag.getAttribute("", "name");
        String asStr = this.startTag.getAttribute("", "as");
        String requiredStr = Whitespace.trim(this.startTag.getAttribute("", "required"));
        boolean isRequired = StyleElement.isYes(requiredStr);
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
        staticContext.setBaseURI(baseUri.toString());
        staticContext.setContainingLocation(new AttributeLocation(elemName.getStructuredQName(), new StructuredQName("", "", "as"), location));
        SequenceType requiredType = SequenceType.ANY_SEQUENCE;
        int languageLevel = this.compilation.getConfiguration().getConfigurationProperty(Feature.XPATH_VERSION_FOR_XSLT);
        if (languageLevel == 30) {
            languageLevel = 305;
        }
        if (asStr != null) {
            XPathParser parser = this.compilation.getConfiguration().newExpressionParser("XP", false, languageLevel);
            requiredType = parser.parseSequenceType(asStr, staticContext);
        }
        try {
            varName = StructuredQName.fromLexicalQName(nameStr, false, true, this.startTag);
        }
        catch (XPathException err) {
            throw this.createXPathException("Invalid variable name:" + nameStr + ". " + err.getMessage(), err.getErrorCodeLocalPart(), location);
        }
        boolean isVariable = elemName.getLocalPart().equals("variable");
        boolean isParam = elemName.getLocalPart().equals("param");
        boolean isSupplied = isParam && this.compilation.getParameters().containsKey(varName);
        AttributeLocation attLoc = new AttributeLocation(elemName.getStructuredQName(), new StructuredQName("", "", "select"), location);
        if (isParam) {
            if (isRequired && !isSupplied) {
                String selectStr = this.startTag.getAttribute("", "select");
                if (selectStr != null) {
                    throw this.createXPathException("Cannot supply a default value when required='yes'", "XTSE0010", attLoc);
                }
                throw this.createXPathException("No value was supplied for the required static parameter $" + varName.getDisplayName(), "XTDE0050", location);
            }
            if (isSupplied) {
                GroundedValue<?> suppliedValue = this.compilation.getParameters().convertParameterValue(varName, requiredType, true, staticContext.makeEarlyEvaluationContext());
                this.compilation.declareStaticVariable(varName, suppliedValue.materialize(), precedence, isParam);
            }
        }
        if (isVariable || !isSupplied) {
            GroundedValue<AtomicValue> value;
            String selectStr = this.startTag.getAttribute("", "select");
            if (selectStr == null) {
                if (isVariable) {
                    throw this.createXPathException("The select attribute is required for a static global variable", "XTSE0010", location);
                }
                if (!Cardinality.allowsZero(requiredType.getCardinality())) {
                    throw this.createXPathException("The parameter is implicitly required because it does not accept an empty sequence, but no value has been supplied", "XTDE0700", location);
                }
                value = asStr == null ? StringValue.EMPTY_STRING : EmptySequence.getInstance();
                this.compilation.declareStaticVariable(varName, value, precedence, isParam);
            } else {
                try {
                    staticContext.setContainingLocation(attLoc);
                    Sequence<?> seq = this.evaluateStatic(selectStr, location, staticContext);
                    value = seq.materialize();
                }
                catch (XPathException e) {
                    throw this.createXPathException("Error in " + elemName.getLocalPart() + " expression. " + e.getMessage(), e.getErrorCodeLocalPart(), attLoc);
                }
            }
            RoleDiagnostic role = new RoleDiagnostic(3, varName.getDisplayName(), 0);
            role.setErrorCode("XTDE0050");
            TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
            Sequence<?> seq = th.applyFunctionConversionRules(value, requiredType, role, attLoc);
            value = seq.materialize();
            try {
                this.compilation.declareStaticVariable(varName, value, precedence, isParam);
            }
            catch (XPathException e) {
                throw this.createXPathException(e.getMessage(), e.getErrorCodeLocalPart(), attLoc);
            }
        }
    }

    private void processShadowAttributes(NodeName elemName, Location location, URI baseUri) throws XPathException {
        AttributeCollection atts = this.startTag.getAllAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            String local = atts.getLocalName(a);
            String uri = atts.getURI(a);
            if (!local.startsWith("_") || !uri.isEmpty() && !uri.equals("http://saxon.sf.net/") || local.length() < 2) continue;
            String value = atts.getValue(a);
            AttributeLocation attLocation = new AttributeLocation(elemName.getStructuredQName(), atts.getNodeName(a).getStructuredQName(), location);
            String newValue = this.processShadowAttribute(value, baseUri.toString(), attLocation);
            String plainName = local.substring(1);
            NodeName newName = uri.isEmpty() ? new NoNamespaceName(plainName) : new FingerprintedQName(atts.getPrefix(a), "http://saxon.sf.net/", plainName);
            int index = atts.getIndex("", plainName);
            if (index == -1) {
                index = a;
            }
            ((AttributeCollectionImpl)atts).setAttribute(index, newName, BuiltInAtomicType.UNTYPED_ATOMIC, newValue, atts.getLocation(a), 0);
        }
    }

    private URI processBaseUri(Location location) throws XPathException {
        URI baseUri;
        String systemId = location.getSystemId();
        if (systemId == null) {
            systemId = this.getSystemId();
        }
        if (systemId == null || systemId.equals(this.systemIdStack.peek())) {
            baseUri = this.baseUriStack.peek();
        } else {
            try {
                baseUri = new URI(systemId);
            }
            catch (URISyntaxException e) {
                throw new XPathException("Invalid URI for stylesheet entity: " + systemId);
            }
        }
        String baseUriAtt = this.startTag.getAttribute("http://www.w3.org/XML/1998/namespace", "base");
        if (baseUriAtt != null) {
            try {
                baseUri = baseUri.resolve(baseUriAtt);
            }
            catch (IllegalArgumentException iae) {
                throw new XPathException("Invalid URI in xml:base attribute: " + baseUriAtt + ". " + iae.getMessage());
            }
        }
        this.baseUriStack.push(baseUri);
        this.systemIdStack.push(systemId);
        return baseUri;
    }

    private int processVersionAttribute(String version) throws XPathException {
        if (version != null) {
            ConversionResult cr = BigDecimalValue.makeDecimalValue(version, true);
            if (cr instanceof ValidationFailure) {
                throw new XPathException("Invalid version number: " + version, "XTSE0110");
            }
            BigDecimalValue d = (BigDecimalValue)cr.asAtomic();
            return d.getDecimalValue().multiply(BigDecimal.TEN).intValue();
        }
        return Integer.MIN_VALUE;
    }

    private String processShadowAttribute(String expression, String baseUri, AttributeLocation loc) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
        staticContext.setBaseURI(baseUri);
        staticContext.setContainingLocation(loc);
        this.setNamespaceBindings(staticContext);
        Expression expr = AttributeValueTemplate.make(expression, staticContext);
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.allocateSlots(expression, expr);
        XPathContext dynamicContext = this.makeDynamicContext(staticContext);
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return expr.evaluateAsString(dynamicContext).toString();
    }

    public XPathException createXPathException(String message, String errorCode, Location location) {
        XPathException err = new XPathException(message);
        err.setErrorCode(errorCode);
        err.setIsStaticError(true);
        err.setLocator(location.saveLocation());
        this.getPipelineConfiguration().getErrorListener().fatalError(err);
        err.setHasBeenReported(true);
        return err;
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(namespaceBindings, properties);
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (!(this.depthOfHole != 0 || this.dropUnderscoredAttributes && attName.getLocalPart().startsWith("_") && attName.hasURI(""))) {
            this.nextReceiver.attribute(attName, typeCode, value, locationId, properties);
        }
    }

    @Override
    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
            if (this.includedDoc != null) {
                XSLGeneralIncorporate declaration = (XSLGeneralIncorporate)((LinkedTreeBuilder)this.nextReceiver).getCurrentParentNode();
                declaration.setTargetDoc(this.includedDoc);
            }
        }
        this.dropUnderscoredAttributes = false;
        this.includedDoc = null;
    }

    @Override
    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.systemIdStack.pop();
            this.baseUriStack.pop();
            this.versionStack.pop();
            this.nextReceiver.endElement();
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) {
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
    }

    public boolean evaluateUseWhen(String expression, AttributeLocation location, String baseUri) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
        staticContext.setBaseURI(baseUri);
        staticContext.setContainingLocation(location);
        this.setNamespaceBindings(staticContext);
        Expression expr = ExpressionTool.make(expression, staticContext, 0, 0, null);
        expr.setRetainedStaticContext(staticContext.makeRetainedStaticContext());
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.allocateSlots(expression, expr);
        XPathContext dynamicContext = this.makeDynamicContext(staticContext);
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return expr.effectiveBooleanValue(dynamicContext);
    }

    private SlotManager allocateSlots(String expression, Expression expr) {
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        if (expression.indexOf(36) >= 0) {
            ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        }
        return stackFrameMap;
    }

    private void setNamespaceBindings(UseWhenStaticContext staticContext) {
        staticContext.setDefaultElementNamespace("");
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            String uri = (String)this.defaultNamespaceStack.get(i);
            if (uri == null) continue;
            staticContext.setDefaultElementNamespace(uri);
            break;
        }
    }

    private Expression typeCheck(Expression expr, UseWhenStaticContext staticContext) throws XPathException {
        ItemType contextItemType = Type.ITEM_TYPE;
        ContextItemStaticInfo cit = this.getConfiguration().makeContextItemStaticInfo(contextItemType, true);
        ExpressionVisitor visitor = ExpressionVisitor.make(staticContext);
        return expr.typeCheck(visitor, cit);
    }

    private XPathContext makeDynamicContext(UseWhenStaticContext staticContext) throws XPathException {
        Controller controller = new Controller(this.getConfiguration());
        controller.getExecutable().setFunctionLibrary((FunctionLibraryList)staticContext.getFunctionLibrary());
        if (staticContext.getXPathVersion() < 30) {
            controller.setURIResolver(new URIPreventer());
        }
        controller.setCurrentDateTime(this.currentDateTime);
        XPathContextMajor dynamicContext = controller.newXPathContext();
        dynamicContext = dynamicContext.newCleanContext();
        return dynamicContext;
    }

    public Sequence<?> evaluateStatic(String expression, Location locationId, UseWhenStaticContext staticContext) throws XPathException {
        this.setNamespaceBindings(staticContext);
        Expression expr = ExpressionTool.make(expression, staticContext, 0, 0, null);
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        XPathContext dynamicContext = this.makeDynamicContext(staticContext);
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return expr.iterate(dynamicContext).materialize();
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        @Override
        public Source resolve(String href, String base) throws XPathException {
            throw new XPathException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

