/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.completion;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import net.sourceforge.squirrel_sql.fw.completion.CompletionCandidates;
import net.sourceforge.squirrel_sql.fw.completion.CompletionFocusHandler;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.CompletorListener;
import net.sourceforge.squirrel_sql.fw.completion.ICompletorModel;
import net.sourceforge.squirrel_sql.fw.completion.PopupManager;
import net.sourceforge.squirrel_sql.fw.completion.TextComponentProvider;

public class Completor {
    public static final Color DEFAULT_POP_UP_BACK_GROUND = new Color(255, 255, 204);
    private Vector<CompletorListener> _listeners = new Vector();
    private ICompletorModel _model;
    private JPanel _completionPanel;
    private JList _completionList;
    private Rectangle _curCompletionPanelSize;
    private PopupManager _popupMan;
    private TextComponentProvider _txtComp;
    private CompletionFocusHandler _completionFocusHandler;
    private FocusListener _completionFocusListener;
    private MouseAdapter _listMouseAdapter;
    private KeyListener _filterKeyListener;
    private static final int MAX_ITEMS_IN_COMPLETION_LIST = 10;
    private JScrollPane _completionListScrollPane;
    private CompletionCandidates _currCandidates;
    private KeyStroke[] _keysToDisableWhenPopUpOpen = new KeyStroke[]{KeyStroke.getKeyStroke(10, 0, false), KeyStroke.getKeyStroke(32, 0, false), KeyStroke.getKeyStroke(37, 0, false), KeyStroke.getKeyStroke(39, 0, false), KeyStroke.getKeyStroke(38, 0, false), KeyStroke.getKeyStroke(40, 0, false), KeyStroke.getKeyStroke(9, 0, false), KeyStroke.getKeyStroke(33, 0, false), KeyStroke.getKeyStroke(34, 0, false), KeyStroke.getKeyStroke(32, 2, false)};
    private Action[] _originalActions = null;

    public Completor(JTextComponent txtComp, ICompletorModel model) {
        this(txtComp, model, DEFAULT_POP_UP_BACK_GROUND, false, txtComp);
    }

    public Completor(JTextComponent txtComp, ICompletorModel model, Color popUpBackGround, boolean useOwnFilterTextField) {
        this(txtComp, model, popUpBackGround, useOwnFilterTextField, txtComp);
    }

    public Completor(JTextComponent txtComp, ICompletorModel model, Color popUpBackGround, boolean useOwnFilterTextField, JComponent popupParent) {
        this._txtComp = new TextComponentProvider(txtComp, useOwnFilterTextField);
        this._model = model;
        this._completionPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSize(int width, int height) {
                super.setSize(((Completor)Completor.this)._curCompletionPanelSize.width, ((Completor)Completor.this)._curCompletionPanelSize.height);
            }
        };
        this._completionList = new JList(new DefaultListModel());
        this._completionList.setSelectionMode(0);
        this._completionList.setBackground(popUpBackGround);
        this._completionFocusHandler = new CompletionFocusHandler(this._txtComp, this._completionList);
        this._completionFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Completor.this.closePopup();
            }
        };
        this._listMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Completor.this.onMousClicked(e);
            }
        };
        this._filterKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Completor.this.onKeyPressedOnList(e);
            }
        };
        this._completionListScrollPane = new JScrollPane(this._completionList);
        if (this._txtComp.editorEqualsFilter()) {
            this._completionPanel.add((Component)this._completionListScrollPane, "Center");
        } else {
            this._completionPanel.add((Component)this._txtComp.getFilter(), "North");
            this._completionPanel.add((Component)this._completionListScrollPane, "Center");
        }
        this._completionPanel.setVisible(false);
        this._popupMan = new PopupManager(popupParent);
    }

    private void onKeyPressedOnList(KeyEvent e) {
        if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
            this.completionSelected(e.getKeyCode(), e.getModifiers());
        } else if (e.getKeyCode() == 27) {
            this.closePopup();
        } else if (e.getKeyCode() == 8) {
            if (this._txtComp.editorEqualsFilter() && 1 >= this._currCandidates.getStringToReplace().length()) {
                this.closePopup();
            } else {
                this.reInitList();
            }
        } else if (e.getKeyCode() != 37 && e.getKeyCode() != 39 && e.getKeyCode() != 9) {
            if (e.getKeyCode() == 38) {
                if (0 < this._completionList.getSelectedIndex()) {
                    int newSelIx = this._completionList.getSelectedIndex() - 1;
                    this._completionList.setSelectionInterval(newSelIx, newSelIx);
                    this._completionList.ensureIndexIsVisible(newSelIx);
                } else {
                    int lastIx = this._completionList.getModel().getSize() - 1;
                    this._completionList.setSelectionInterval(lastIx, lastIx);
                    this._completionList.ensureIndexIsVisible(lastIx);
                }
            } else if (e.getKeyCode() == 40) {
                if (this._completionList.getSelectedIndex() + 1 < this._completionList.getModel().getSize()) {
                    int newSelIx = this._completionList.getSelectedIndex() + 1;
                    this._completionList.setSelectionInterval(newSelIx, newSelIx);
                    this._completionList.ensureIndexIsVisible(newSelIx);
                } else {
                    this._completionList.setSelectionInterval(0, 0);
                    this._completionList.ensureIndexIsVisible(0);
                }
            } else if (e.getKeyCode() == 33) {
                if (0 < this._completionList.getSelectedIndex() - 10) {
                    int newSelIx = this._completionList.getSelectedIndex() - 10;
                    this._completionList.setSelectionInterval(newSelIx, newSelIx);
                    this._completionList.ensureIndexIsVisible(newSelIx);
                } else {
                    this._completionList.setSelectionInterval(0, 0);
                    this._completionList.ensureIndexIsVisible(0);
                }
            } else if (e.getKeyCode() == 34) {
                if (this._completionList.getSelectedIndex() + 10 < this._completionList.getModel().getSize()) {
                    int newSelIx = this._completionList.getSelectedIndex() + 10;
                    this._completionList.setSelectionInterval(newSelIx, newSelIx);
                    this._completionList.ensureIndexIsVisible(newSelIx);
                } else {
                    int lastIndex = this._completionList.getModel().getSize() - 1;
                    this._completionList.setSelectionInterval(lastIndex, lastIndex);
                    this._completionList.ensureIndexIsVisible(lastIndex);
                }
            } else {
                this.reInitList();
                DefaultListModel listModel = (DefaultListModel)this._completionList.getModel();
                if (1 == listModel.size()) {
                    CompletionInfo info = (CompletionInfo)listModel.getElementAt(0);
                    if (this._txtComp.editorEqualsFilter() && this._currCandidates.getStringToReplace().toUpperCase().startsWith(info.getCompareString().toUpperCase())) {
                        this.closePopup();
                    }
                }
            }
        }
    }

    private void reInitList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Completor.this.reInitListLater();
            }
        });
    }

    private void reInitListLater() {
        this._currCandidates = this._model.getCompletionCandidates(this.getTextTillCarret());
        if (0 == this._currCandidates.getCandidates().length && this._txtComp.editorEqualsFilter()) {
            this.closePopup();
        } else {
            this.fillAndShowCompletionList(this._currCandidates.getCandidates());
        }
    }

    public String getTextTillCarret() {
        try {
            if (this._txtComp.editorEqualsFilter()) {
                return this._txtComp.getEditor().getText(0, this._txtComp.getFilter().getCaretPosition());
            }
            return this._txtComp.getFilter().getText();
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void onMousClicked(MouseEvent e) {
        if (2 == e.getClickCount()) {
            this.completionSelected(10, 0);
        }
    }

    private void completionSelected(int keyCode, int modifiers) {
        Object selected = null;
        if (0 < this._completionList.getModel().getSize()) {
            selected = this._completionList.getSelectedValue();
        }
        this.closePopup();
        if (null != selected && selected instanceof CompletionInfo) {
            this.fireEvent(selected, keyCode, modifiers);
        }
    }

    private void closePopup() {
        this._completionList.removeMouseListener(this._listMouseAdapter);
        this._txtComp.getFilter().removeKeyListener(this._filterKeyListener);
        this._completionFocusHandler.setFocusListener(null);
        this._completionPanel.setVisible(false);
        if (this._txtComp.editorEqualsFilter()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Keymap km = Completor.this._txtComp.getEditor().getKeymap();
                    for (int i = 0; i < Completor.this._keysToDisableWhenPopUpOpen.length; ++i) {
                        km.removeKeyStrokeBinding(Completor.this._keysToDisableWhenPopUpOpen[i]);
                        if (null == Completor.this._originalActions[i]) continue;
                        km.addActionForKeyStroke(Completor.this._keysToDisableWhenPopUpOpen[i], Completor.this._originalActions[i]);
                    }
                }
            });
        } else {
            this._txtComp.getFilter().setText("");
            this._txtComp.getEditor().requestFocusInWindow();
        }
    }

    public void show() {
        try {
            this._currCandidates = this._model.getCompletionCandidates(this.getTextTillCarret());
            if (0 == this._currCandidates.getCandidates().length) {
                return;
            }
            if (1 == this._currCandidates.getCandidates().length) {
                this.fireEvent(this._currCandidates.getCandidates()[0], 10, 0);
                return;
            }
            this._txtComp.getEditor().modelToView(this._currCandidates.getReplacementStart());
            this._completionList.setFont(this._txtComp.getEditor().getFont());
            this.fillAndShowCompletionList(this._currCandidates.getCandidates());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void fillAndShowCompletionList(CompletionInfo[] candidates) {
        try {
            this._curCompletionPanelSize = this.getCurCompletionPanelSize(candidates);
            DefaultListModel model = (DefaultListModel)this._completionList.getModel();
            model.removeAllElements();
            for (int i = 0; i < candidates.length; ++i) {
                model.addElement(candidates[i]);
            }
            Rectangle caretBounds = this._txtComp.editorEqualsFilter() ? this._txtComp.getEditor().modelToView(this._currCandidates.getReplacementStart()) : this._txtComp.getEditor().modelToView(this._txtComp.getEditor().getCaretPosition());
            this._popupMan.install(this._completionPanel, caretBounds, PopupManager.BelowPreferred);
            this._completionList.setSelectedIndex(0);
            this._completionList.ensureIndexIsVisible(0);
            this._completionPanel.setVisible(true);
            this._completionList.removeMouseListener(this._listMouseAdapter);
            this._completionList.addMouseListener(this._listMouseAdapter);
            this._txtComp.getFilter().removeKeyListener(this._filterKeyListener);
            this._txtComp.getFilter().addKeyListener(this._filterKeyListener);
            this._completionFocusHandler.setFocusListener(this._completionFocusListener);
            if (this._txtComp.editorEqualsFilter()) {
                int i;
                AbstractAction doNothingAction = new AbstractAction("doNothingAction"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
                Keymap km = this._txtComp.getEditor().getKeymap();
                if (null == this._originalActions) {
                    this._originalActions = new Action[this._keysToDisableWhenPopUpOpen.length];
                    for (i = 0; i < this._keysToDisableWhenPopUpOpen.length; ++i) {
                        this._originalActions[i] = km.getAction(this._keysToDisableWhenPopUpOpen[i]);
                    }
                }
                for (i = 0; i < this._keysToDisableWhenPopUpOpen.length; ++i) {
                    km.addActionForKeyStroke(this._keysToDisableWhenPopUpOpen[i], doNothingAction);
                }
            } else {
                this._txtComp.getFilter().requestFocusInWindow();
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private Rectangle getCurCompletionPanelSize(CompletionInfo[] candidates) {
        FontMetrics fm = this._txtComp.getEditor().getGraphics().getFontMetrics(this._txtComp.getEditor().getFont());
        int width = this.getCurCompletionPanelWidth(candidates, fm) + 30;
        int height = (int)((double)Math.min(candidates.length, 10) * ((double)fm.getHeight() + 2.3) + 3.0);
        if (!this._txtComp.editorEqualsFilter()) {
            height = (int)((double)height + this._txtComp.getFilter().getPreferredSize().getHeight());
        }
        return new Rectangle(width, height);
    }

    private int getCurCompletionPanelWidth(CompletionInfo[] infos, FontMetrics fontMetrics) {
        int maxSize = 0;
        if (!this._txtComp.editorEqualsFilter() && null != this._txtComp.getFilter().getText()) {
            maxSize = Math.max(fontMetrics.stringWidth(this._txtComp.getFilter().getText() + "   "), maxSize);
        }
        for (int i = 0; i < infos.length; ++i) {
            maxSize = Math.max(fontMetrics.stringWidth(infos[i].toString()), maxSize);
        }
        return maxSize;
    }

    private void fireEvent(CompletionInfo completion, int keyCode, int modifiers) {
        Vector<CompletorListener> clone = new Vector<CompletorListener>(this._listeners);
        for (int i = 0; i < clone.size(); ++i) {
            CompletorListener completorListener = clone.elementAt(i);
            if (this._txtComp.editorEqualsFilter()) {
                completorListener.completionSelected(completion, this._currCandidates.getReplacementStart(), keyCode, modifiers);
                continue;
            }
            completorListener.completionSelected(completion, -1, keyCode, modifiers);
        }
    }

    public void addCodeCompletorListener(CompletorListener l) {
        this._listeners.add(l);
    }

    public void removeCodeCompletorListener(CompletorListener l) {
        this._listeners.remove(l);
    }
}

