/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IMainFrame;
import net.sourceforge.squirrel_sql.fw.datasetviewer.PopupEditableIOPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CellDataPopup {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CellDataPopup.class);

    public static void showDialog(JTable table, ColumnDisplayDefinition colDef, MouseEvent evt, boolean isModelEditable) {
        CellDataPopup popup = new CellDataPopup();
        popup.createAndShowDialog(table, evt, colDef, isModelEditable);
    }

    private void createAndShowDialog(JTable table, MouseEvent evt, ColumnDisplayDefinition colDef, boolean isModelEditable) {
        Point pt = evt.getPoint();
        int row = table.rowAtPoint(pt);
        int col = table.columnAtPoint(pt);
        Object obj = table.getValueAt(row, col);
        TableCellEditor editor = table.getCellEditor(row, col);
        if (editor != null) {
            editor.cancelCellEditing();
        }
        Component comp = SwingUtilities.getRoot(table);
        TextAreaInternalFrame newComp = null;
        if (!(comp instanceof JFrame)) {
            return;
        }
        TextAreaInternalFrame taif = new TextAreaInternalFrame((JFrame)comp, table.getColumnName(col), colDef, obj, row, col, isModelEditable, table);
        taif.pack();
        newComp = taif;
        Dimension dim = newComp.getSize();
        boolean dimChanged = false;
        if (dim.width < 300) {
            dim.width = 300;
            dimChanged = true;
        }
        if (dim.height < 300) {
            dim.height = 300;
            dimChanged = true;
        }
        if (dim.width > 600) {
            dim.width = 600;
            dimChanged = true;
        }
        if (dim.height > 500) {
            dim.height = 500;
            dimChanged = true;
        }
        if (dimChanged) {
            ((Component)newComp).setSize(dim);
        }
        if (comp instanceof IMainFrame) {
            pt = SwingUtilities.convertPoint((Component)evt.getSource(), pt, comp);
            pt.y -= dim.height;
        } else {
            Window parent = SwingUtilities.windowForComponent(comp);
            while (parent != null && !(parent instanceof IMainFrame) && !parent.equals(comp)) {
                comp = parent;
                parent = SwingUtilities.windowForComponent(comp);
            }
            comp = parent != null ? parent : comp;
            pt = SwingUtilities.convertPoint((Component)evt.getSource(), pt, comp);
        }
        if (pt.y < 0) {
            pt.y = 0;
        }
        int fudgeFactor = 100;
        Rectangle parentBounds = comp.getBounds();
        if (parentBounds.width <= dim.width + fudgeFactor) {
            dim.width = parentBounds.width - fudgeFactor;
            pt.x = fudgeFactor / 2;
            ((Component)newComp).setSize(dim);
        } else if (pt.x + dim.width + fudgeFactor > parentBounds.width) {
            pt.x -= pt.x + dim.width + fudgeFactor - parentBounds.width;
        }
        ((Component)newComp).setLocation(pt);
        ((Component)newComp).setVisible(true);
    }

    class TextAreaInternalFrame
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public TextAreaInternalFrame(JFrame owner, String columnName, ColumnDisplayDefinition colDef, Object value, int row, int col, boolean isModelEditable, JTable table) {
            super(owner, s_stringMgr.getString("cellDataPopup.valueofColumn", columnName), false);
            ColumnDataPopupPanel popup = new ColumnDataPopupPanel(value, colDef, isModelEditable);
            popup.setUserActionInfo(this, row, col, table);
            this.setContentPane(popup);
            AbstractAction closeAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TextAreaInternalFrame.this.setVisible(false);
                    TextAreaInternalFrame.this.dispose();
                }
            };
            KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
            this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
            this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
            this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
            this.getRootPane().getActionMap().put("CloseAction", closeAction);
        }
    }

    private static class ColumnDataPopupPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final PopupEditableIOPanel ioPanel;
        private JDialog _parentFrame = null;
        private int _row;
        private int _col;
        private JTable _table;

        ColumnDataPopupPanel(Object cellContents, ColumnDisplayDefinition colDef, boolean tableIsEditable) {
            super(new BorderLayout());
            if (tableIsEditable && CellComponentFactory.isEditableInPopup(colDef, cellContents)) {
                this.ioPanel = new PopupEditableIOPanel(colDef, cellContents, true);
                JPanel editingControls = this.createPopupEditingControls();
                this.add((Component)editingControls, "South");
            } else {
                this.ioPanel = new PopupEditableIOPanel(colDef, cellContents, false);
            }
            this.add((Component)this.ioPanel, "Center");
        }

        private JPanel createPopupEditingControls() {
            JPanel panel = new JPanel(new BorderLayout());
            JPanel updateControls = new JPanel();
            JButton updateButton = new JButton(s_stringMgr.getString("cellDataPopUp.updateData"));
            updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    StringBuffer messageBuffer = new StringBuffer();
                    Object newValue = ColumnDataPopupPanel.this.ioPanel.getObject(messageBuffer);
                    if (messageBuffer.length() > 0) {
                        String msg = s_stringMgr.getString("cellDataPopUp.cannnotBGeConverted", messageBuffer);
                        JOptionPane.showMessageDialog(ColumnDataPopupPanel.this, msg, s_stringMgr.getString("cellDataPopUp.conversionError"), 0);
                        ColumnDataPopupPanel.this.ioPanel.requestFocus();
                    } else {
                        ColumnDataPopupPanel.this._table.setValueAt(newValue, ColumnDataPopupPanel.this._row, ColumnDataPopupPanel.this._col);
                        ColumnDataPopupPanel.this._parentFrame.setVisible(false);
                        ColumnDataPopupPanel.this._parentFrame.dispose();
                    }
                }
            });
            JButton cancelButton = new JButton(s_stringMgr.getString("cellDataPopup.cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ColumnDataPopupPanel.this._parentFrame.setVisible(false);
                    ColumnDataPopupPanel.this._parentFrame.dispose();
                }
            });
            updateControls.add(updateButton);
            updateControls.add(cancelButton);
            panel.add((Component)updateControls, "South");
            return panel;
        }

        public void setUserActionInfo(JDialog parent, int row, int col, JTable table) {
            this._parentFrame = parent;
            this._row = row;
            this._col = col;
            this._table = table;
        }
    }
}

