/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetMetaDataDataSet
implements IDataSet {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultSetMetaDataDataSet.class);
    private static ILogger s_log = LoggerController.createLogger(ResultSetMetaDataDataSet.class);
    private DataSetDefinition _dsDef;
    private boolean[] _propertyMethodIndicators;
    private Iterator<Object[]> _rowsIter;
    private Object[] _row;
    private List<Object[]> _data = new ArrayList<Object[]>();
    private static final Map<String, Object> s_propNames = new HashMap<String, Object>();

    public ResultSetMetaDataDataSet(ResultSet rs) throws IllegalArgumentException, DataSetException {
        this(ResultSetMetaDataDataSet.getMetaDataFromResultSet(rs));
    }

    public ResultSetMetaDataDataSet(ResultSetMetaData md) throws IllegalArgumentException, DataSetException {
        this.setResultSetMetaData(md);
    }

    public synchronized void setResultSetMetaData(ResultSetMetaData md) throws DataSetException {
        this._dsDef = new DataSetDefinition(this.createColumnDefinitions());
        this.load(md);
    }

    @Override
    public final int getColumnCount() {
        return this._dsDef.getColumnDefinitions().length;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dsDef;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        this._row = this._rowsIter.hasNext() ? this._rowsIter.next() : null;
        return this._row != null;
    }

    @Override
    public synchronized Object get(int columnIndex) {
        return this._row[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        Method[] methods = ResultSetMetaData.class.getMethods();
        this._propertyMethodIndicators = new boolean[methods.length];
        ArrayList<ColumnDisplayDefinition> colDefs = new ArrayList<ColumnDisplayDefinition>();
        for (int i = 0; i < methods.length; ++i) {
            if (this.isPropertyMethod(methods[i])) {
                colDefs.add(new ColumnDisplayDefinition(200, methods[i].getName()));
                this._propertyMethodIndicators[i] = true;
                continue;
            }
            this._propertyMethodIndicators[i] = false;
        }
        return colDefs.toArray(new ColumnDisplayDefinition[colDefs.size()]);
    }

    private void load(ResultSetMetaData md) throws DataSetException {
        try {
            Method[] methods = ResultSetMetaData.class.getMethods();
            ArrayList<Object> line = new ArrayList<Object>();
            int metaLimit = md.getColumnCount() + 1;
            for (int metaIdx = 1; metaIdx < metaLimit; ++metaIdx) {
                Object[] methodParms = new Object[]{metaIdx};
                line.clear();
                line.ensureCapacity(methods.length);
                for (int methodIdx = 0; methodIdx < methods.length; ++methodIdx) {
                    try {
                        if (!this._propertyMethodIndicators[methodIdx]) continue;
                        Object obj = this.executeGetter(md, methods[methodIdx], methodParms);
                        line.add(obj);
                        continue;
                    }
                    catch (Throwable th) {
                        line.add("<Error>");
                        s_log.error("Error reading column metadata", th);
                    }
                }
                this._data.add(line.toArray(new Object[line.size()]));
            }
            this._rowsIter = this._data.iterator();
        }
        catch (SQLException ex) {
            s_log.error("Error occured processing result set", ex);
            throw new DataSetException(ex);
        }
    }

    protected boolean isPropertyMethod(Method method) {
        return s_propNames.containsKey(method.getName());
    }

    protected Object executeGetter(Object bean, Method getter, Object[] parms) {
        try {
            return getter.invoke(bean, parms);
        }
        catch (Throwable th) {
            return "<Unsupported>";
        }
    }

    private static ResultSetMetaData getMetaDataFromResultSet(ResultSet rs) throws IllegalArgumentException, DataSetException {
        if (rs == null) {
            throw new IllegalArgumentException("Null ResultSet passed");
        }
        try {
            return rs.getMetaData();
        }
        catch (SQLException ex) {
            throw new DataSetException(ex);
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static {
        s_propNames.put("getCatalogName", null);
        s_propNames.put("getColumnClassName", null);
        s_propNames.put("getColumnDisplaySize", null);
        s_propNames.put("getColumnLabel", null);
        s_propNames.put("getColumnName", null);
        s_propNames.put("getColumnType", null);
        s_propNames.put("getColumnTypeName", null);
        s_propNames.put("getPrecision", null);
        s_propNames.put("getScale", null);
        s_propNames.put("getSchemaName", null);
        s_propNames.put("getTableName", null);
        s_propNames.put("isAutoIncrement", null);
        s_propNames.put("isCaseSensitive", null);
        s_propNames.put("isCurrency", null);
        s_propNames.put("isDefinitelyWritable", null);
        s_propNames.put("isNullable", null);
        s_propNames.put("isReadOnly", null);
        s_propNames.put("isSearchable", null);
        s_propNames.put("isSigned", null);
        s_propNames.put("isWritable", null);
    }

    private static interface i18n {
        public static final String UNSUPPORTED = "<Unsupported>";
        public static final String NAME_COLUMN = ResultSetMetaDataDataSet.access$000().getString("resultSetMentaDataSet.propName");
        public static final String VALUE_COLUMN = ResultSetMetaDataDataSet.access$000().getString("resultSetMentaDataSet.val");
    }
}

