/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBigDecimal;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public abstract class FloatingPointBase
extends BaseDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FloatingPointBase.class);
    private static boolean propertiesAlreadyLoaded = false;
    protected static boolean useJavaDefaultFormat = false;

    public static OkJPanel getControlPanel() {
        FloatingPointBase.loadProperties();
        return new FloatingPointOkJPanel();
    }

    public FloatingPointBase() {
        FloatingPointBase.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            useJavaDefaultFormat = false;
            String useJavaDefaultFormatString = DTProperties.get(DataTypeBigDecimal.class.getName(), "useJavaDefaultFormat");
            if (useJavaDefaultFormatString != null && useJavaDefaultFormatString.equals("true")) {
                useJavaDefaultFormat = true;
            }
        }
    }

    private static class FloatingPointOkJPanel
    extends OkJPanel {
        private static final long serialVersionUID = 3745853322636427759L;
        JRadioButton optUseDefaultFormat;
        JRadioButton optUseLocaleDependendFormat;

        public FloatingPointOkJPanel() {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(5);
            this.optUseDefaultFormat = new JRadioButton(s_stringMgr.getString("floatingPointBase.useDefaultFormat", new Double(3.14159).toString()));
            this.optUseLocaleDependendFormat = new JRadioButton(s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat", numberFormat.format(new Double(3.14159))));
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("floatingPointBase.typeBigDecimal")));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)this.optUseLocaleDependendFormat, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 4, 4, 4), 0, 0);
            this.add((Component)this.optUseDefaultFormat, gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.optUseDefaultFormat);
            bg.add(this.optUseLocaleDependendFormat);
            this.optUseLocaleDependendFormat.setSelected(!useJavaDefaultFormat);
            this.optUseDefaultFormat.setSelected(useJavaDefaultFormat);
        }

        @Override
        public void ok() {
            useJavaDefaultFormat = this.optUseDefaultFormat.isSelected();
            DTProperties.put(DataTypeBigDecimal.class.getName(), "useJavaDefaultFormat", Boolean.valueOf(useJavaDefaultFormat).toString());
        }
    }
}

