/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.DB2DialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.DB2Dialect;

public class DerbyDialectExt
extends DB2DialectExt
implements HibernateDialect {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DerbyDialectExt.class);
    private DerbyDialectHelper _dialect = new DerbyDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        return true;
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 8 || dataType == 6) {
            return 48;
        }
        return 31;
    }

    @Override
    public int getMaxScale(int dataType) {
        return this.getMaxPrecision(dataType);
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public String getDisplayName() {
        return "Derby";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("Apache Derby");
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = false;
        boolean addNullClause = true;
        String sql = DialectUtils.getAddColumSQL(column, this, true, false, true, qualifier, prefs);
        return new String[]{sql};
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, false, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] colInfos, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        String alterClause = "ALTER COLUMN";
        DialectUtils.getMultiColNotNullSQL(colInfos, this, "ALTER COLUMN", false, result, qualifier, prefs);
        result.add(DialectUtils.getAddPrimaryKeySQL(ti, pkName, colInfos, false, qualifier, prefs, this));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        boolean featureId = false;
        String msg = DialectUtils.getUnsupportedMessage(this, 0);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        boolean specifyColumnType = false;
        return new String[]{DialectUtils.getColumnNullableAlterSQL(info, this, "ALTER COLUMN", false, qualifier, prefs)};
    }

    @Override
    public boolean supportsRenameColumn() {
        return false;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 3;
        String msg = DialectUtils.getUnsupportedMessage(this, 3);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        if (from.getDataType() != to.getDataType()) {
            throw new UnsupportedOperationException(i18n.TYPE_MESSAGE);
        }
        if (from.getDataType() != 12) {
            throw new UnsupportedOperationException(i18n.VARCHAR_MESSAGE);
        }
        if (from.getColumnSize() > to.getColumnSize()) {
            throw new UnsupportedOperationException(i18n.COLUMN_LENGTH_MESSAGE);
        }
        return super.getColumnTypeAlterSQL(from, to, qualifier, prefs);
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean featureId = true;
        String msg = DialectUtils.getUnsupportedMessage(this, 1);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, false, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.DERBY;
    }

    @Override
    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 15;
        String msg = DialectUtils.getUnsupportedMessage(this, 15);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsDropSequence() {
        return false;
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 18;
        String msg = DialectUtils.getUnsupportedMessage(this, 18);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsSequence() {
        return false;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 17;
        String msg = DialectUtils.getUnsupportedMessage(this, 17);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 16;
        String msg = DialectUtils.getUnsupportedMessage(this, 16);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList result = new ArrayList();
        ArrayList<String> columnNotNullAlters = new ArrayList<String>();
        boolean specifyColumnType = false;
        String alterClause = "ALTER COLUMN";
        for (TableColumnInfo column : columns) {
            if (!column.isNullable().equalsIgnoreCase("YES")) continue;
            columnNotNullAlters.add(DialectUtils.getColumnNullableAlterSQL(column, false, this, "ALTER COLUMN", false, qualifier, prefs));
        }
        result.addAll(columnNotNullAlters);
        result.add(DialectUtils.getAddUniqueConstraintSQL(tableName, constraintName, columns, qualifier, prefs, (HibernateDialect)this));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("select v.VIEWDEFINITION ");
        result.append("from sys.SYSVIEWS v, sys.SYSTABLES t, sys.SYSSCHEMAS s ");
        result.append("where v.TABLEID = t.TABLEID ");
        result.append("and s.SCHEMAID = t.SCHEMAID ");
        result.append("and UPPER(t.TABLENAME) = '");
        result.append(viewName.toUpperCase());
        result.append("' and UPPER(s.SCHEMANAME) = '");
        result.append(qualifier.getSchema().toUpperCase());
        result.append("'");
        return result.toString();
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class DerbyDialectHelper
    extends DB2Dialect {
        public DerbyDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, 254, "char($l) for bit data");
            this.registerColumnType(-2, "blob");
            this.registerColumnType(-7, "smallint");
            this.registerColumnType(2004, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(2004, "blob(1073741823)");
            this.registerColumnType(16, "smallint");
            this.registerColumnType(1, 254, "char($l)");
            this.registerColumnType(1, 4000, "varchar($l)");
            this.registerColumnType(1, 32700, "long varchar");
            this.registerColumnType(1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(1, "clob(1073741823)");
            this.registerColumnType(2005, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(2005, "clob(1073741823)");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p)");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, 32700, "long varchar for bit data");
            this.registerColumnType(-4, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(-4, "blob(1073741823)");
            this.registerColumnType(-1, 32700, "long varchar");
            this.registerColumnType(-1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-1, "clob(1073741823)");
            this.registerColumnType(2, "bigint");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(-3, 254, "long varchar for bit data");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(12, 4000, "varchar($l)");
            this.registerColumnType(12, 32700, "long varchar");
            this.registerColumnType(12, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(12, "clob(1073741823)");
        }
    }

    private static interface i18n {
        public static final String TYPE_MESSAGE = DerbyDialectExt.access$000().getString("DerbyDialect.typeMessage");
        public static final String VARCHAR_MESSAGE = DerbyDialectExt.access$000().getString("DerbyDialect.varcharMessage");
        public static final String COLUMN_LENGTH_MESSAGE = DerbyDialectExt.access$000().getString("DerbyDialect.columnLengthMessage");
    }
}

