/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jxl.Workbook;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvController;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TableExportCsvCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableExportCsvCommand.class);
    private static ILogger s_log = LoggerController.createLogger(TableExportCsvCommand.class);
    private JTable _table;

    public TableExportCsvCommand(JTable table) {
        this._table = table;
    }

    public void execute() {
        boolean writeFileSuccess;
        TableExportCsvController ctrl = new TableExportCsvController();
        if (!ctrl.isOK()) {
            return;
        }
        if (this.checkMissingData(ctrl.getSeparatorChar())) {
            int choice = JOptionPane.showConfirmDialog(GUIUtils.getMainFrame(), i18n.missingClobDataMsg);
            if (choice == 0) {
                // empty if block
            }
            if (choice == 1) {
                return;
            }
            if (choice == 2) {
                return;
            }
        }
        if (writeFileSuccess = this.writeFile(ctrl)) {
            String command = ctrl.getCommand();
            if (null != command) {
                this.executeCommand(command);
            } else {
                String msg = s_stringMgr.getString("TableExportCsvCommand.writeFileSuccess", ctrl.getFile().getAbsolutePath());
                if (s_log.isInfoEnabled()) {
                    s_log.info(msg);
                }
                JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), msg);
            }
        }
    }

    private boolean checkMissingData(String sepChar) {
        int firstSelectedColIdx = this._table.getSelectedColumn();
        int lastSelectedColIdx = firstSelectedColIdx + this._table.getSelectedColumnCount();
        int firstSelectedRowIdx = this._table.getSelectedRow();
        int lastSelectedRowIdx = firstSelectedRowIdx + this._table.getSelectedRowCount();
        for (int colIdx = this._table.getSelectedColumn(); colIdx < lastSelectedColIdx; ++colIdx) {
            ExtTableColumn col = (ExtTableColumn)this._table.getColumnModel().getColumn(colIdx);
            int sqlType = col.getColumnDisplayDefinition().getSqlType();
            if (sqlType != 2005) continue;
            for (int rowIdx = firstSelectedRowIdx; rowIdx < lastSelectedRowIdx; ++rowIdx) {
                Object cellObj = this._table.getValueAt(rowIdx, colIdx);
                String data = this.getDataCSV(sepChar, cellObj);
                if (data == null || !ClobDescriptor.i18n.CLOB_LABEL.equals(data)) continue;
                return true;
            }
        }
        return false;
    }

    private void executeCommand(String command) {
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            Object[] params = new Object[]{command, e.getMessage()};
            String msg = s_stringMgr.getString("TableExportCsvCommand.failedToExecuteCommand", params);
            s_log.error(msg, e);
            JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), msg);
        }
    }

    private boolean writeFile(TableExportCsvController ctrl) {
        File file = null;
        try {
            int[] selCols;
            int[] selRows;
            int nbrSelCols;
            file = ctrl.getFile();
            if (null != file.getParentFile()) {
                file.getParentFile().mkdirs();
            }
            boolean includeHeaders = ctrl.includeHeaders();
            boolean complete = ctrl.exportComplete();
            int nbrSelRows = this._table.getSelectedRowCount();
            if (0 == nbrSelRows || complete) {
                nbrSelRows = this._table.getRowCount();
            }
            if (0 == (nbrSelCols = this._table.getSelectedColumnCount()) || complete) {
                nbrSelCols = this._table.getColumnCount();
            }
            if (0 == (selRows = this._table.getSelectedRows()).length || complete) {
                selRows = new int[nbrSelRows];
                for (int i = 0; i < selRows.length; ++i) {
                    selRows[i] = i;
                }
            }
            if (0 == (selCols = this._table.getSelectedColumns()).length || complete) {
                selCols = new int[nbrSelCols];
                for (int i = 0; i < selCols.length; ++i) {
                    selCols[i] = i;
                }
            }
            if (0 == ctrl.getExportFormat()) {
                return this.writeCSV(file, ctrl, includeHeaders, nbrSelCols, selCols, nbrSelRows, selRows);
            }
            if (1 == ctrl.getExportFormat()) {
                return this.writeXLS(file, includeHeaders, nbrSelCols, selCols, nbrSelRows, ctrl, selRows);
            }
            throw new IllegalStateException("Unknown export format " + ctrl.getExportFormat());
        }
        catch (IOException e) {
            Object[] params = new Object[]{file, e.getMessage()};
            String msg = s_stringMgr.getString("TableExportCsvCommand.failedToWriteFile", params);
            s_log.error(msg, e);
            JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), msg);
            return false;
        }
        catch (WriteException e) {
            Object[] params = new Object[]{file, e.getMessage()};
            String msg = s_stringMgr.getString("TableExportCsvCommand.failedToWriteFile", params);
            s_log.error(msg, e);
            JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), msg);
            return false;
        }
    }

    private boolean writeXLS(File file, boolean includeHeaders, int nbrSelCols, int[] selCols, int nbrSelRows, TableExportCsvController ctrl, int[] selRows) throws IOException, WriteException {
        WritableWorkbook workbook = Workbook.createWorkbook((File)file);
        WritableSheet sheet = workbook.createSheet("Squirrel SQL Export", 0);
        int curRow = 0;
        if (includeHeaders) {
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                String columnName = this._table.getColumnName(selCols[colIdx]);
                Label label = new Label(colIdx, curRow, columnName);
                sheet.addCell((WritableCell)label);
            }
            ++curRow;
        }
        for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                WritableCell xlsCell;
                if (ctrl.useGloablPrefsFormatting() && this._table.getColumnModel().getColumn(colIdx) instanceof ExtTableColumn) {
                    ExtTableColumn col = (ExtTableColumn)this._table.getColumnModel().getColumn(colIdx);
                    xlsCell = this.getXlsCell(col, colIdx, curRow, this._table.getValueAt(selRows[rowIdx], selCols[colIdx]));
                } else {
                    xlsCell = this.getXlsCell(null, colIdx, curRow, this._table.getValueAt(selRows[rowIdx], selCols[colIdx]));
                }
                sheet.addCell(xlsCell);
            }
            ++curRow;
        }
        workbook.write();
        workbook.close();
        return true;
    }

    private WritableCell getXlsCell(ExtTableColumn col, int colIdx, int curRow, Object cellObj) {
        Boolean ret;
        if (null == cellObj) {
            return new Label(colIdx, curRow, this.getDataXLSAsString(cellObj));
        }
        if (null == col) {
            return new Label(colIdx, curRow, this.getDataXLSAsString(cellObj));
        }
        ColumnDisplayDefinition colDef = col.getColumnDisplayDefinition();
        int colType = colDef.getSqlType();
        switch (colType) {
            case -7: 
            case 16: {
                ret = new Boolean(colIdx, curRow, ((java.lang.Boolean)cellObj).booleanValue());
                break;
            }
            case 4: {
                ret = new Number(colIdx, curRow, (double)((java.lang.Number)cellObj).floatValue());
                break;
            }
            case -6: 
            case 5: {
                ret = new Number(colIdx, curRow, (double)((java.lang.Number)cellObj).floatValue());
                break;
            }
            case 3: {
                ret = new Number(colIdx, curRow, (double)((java.lang.Number)cellObj).floatValue());
                break;
            }
            case 2: {
                ret = new Number(colIdx, curRow, (double)((java.lang.Number)cellObj).floatValue());
                break;
            }
            case 6: {
                ret = new Number(colIdx, curRow, (double)((java.lang.Number)cellObj).floatValue());
                break;
            }
            case 8: {
                ret = new Number(colIdx, curRow, (double)((java.lang.Number)cellObj).floatValue());
                break;
            }
            case 7: {
                ret = new Number(colIdx, curRow, (double)((java.lang.Number)cellObj).floatValue());
                break;
            }
            case -5: {
                ret = new Number(colIdx, curRow, (double)Long.parseLong(cellObj.toString()));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long time = ((Date)cellObj).getTime();
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)cellObj);
                int offset = cal.get(15) + cal.get(16);
                Date xlsUTCDate = new Date(time + (long)offset);
                ret = new DateTime(colIdx, curRow, xlsUTCDate, DateTime.GMT);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                cellObj = CellComponentFactory.renderObject(cellObj, col.getColumnDisplayDefinition());
                ret = new Label(colIdx, curRow, this.getDataXLSAsString(cellObj));
                break;
            }
            default: {
                cellObj = CellComponentFactory.renderObject(cellObj, col.getColumnDisplayDefinition());
                ret = new Label(colIdx, curRow, this.getDataXLSAsString(cellObj));
            }
        }
        return ret;
    }

    private String getDataXLSAsString(Object cellObj) {
        if (cellObj == null) {
            return "";
        }
        return cellObj.toString().trim();
    }

    private boolean writeCSV(File file, TableExportCsvController ctrl, boolean includeHeaders, int nbrSelCols, int[] selCols, int nbrSelRows, int[] selRows) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ctrl.getCSVCharset()));
        String separator = ctrl.getSeparatorChar();
        String lineSeparator = ctrl.getLineSeparator();
        if (includeHeaders) {
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                String columnName = this._table.getColumnName(selCols[colIdx]);
                bw.write(this.getDataCSV(separator, columnName));
                if (nbrSelCols - 1 <= colIdx) continue;
                bw.write(separator);
            }
            bw.write(lineSeparator);
        }
        for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                Object cellObj;
                String cellObjData = null;
                if (ctrl.useGloablPrefsFormatting() && this._table.getColumnModel().getColumn(colIdx) instanceof ExtTableColumn) {
                    ExtTableColumn col = (ExtTableColumn)this._table.getColumnModel().getColumn(colIdx);
                    cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                    if (null != cellObj) {
                        cellObj = CellComponentFactory.renderObject(cellObj, col.getColumnDisplayDefinition());
                        cellObjData = this.getDataCSV(separator, cellObj);
                    }
                } else {
                    cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                }
                cellObjData = this.getDataCSV(separator, cellObj);
                bw.write(cellObjData);
                if (nbrSelCols - 1 <= colIdx) continue;
                bw.write(separator);
            }
            bw.write(lineSeparator);
        }
        bw.flush();
        bw.close();
        return true;
    }

    private String getDataCSV(String sepChar, Object cellObj) {
        if (cellObj == null) {
            return "";
        }
        String ret = cellObj.toString().trim();
        if (0 <= ret.indexOf(sepChar) || 0 <= ret.indexOf(10)) {
            ret = "\"" + ret.replaceAll("\"", "\"\"") + "\"";
        }
        return ret;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String missingClobDataMsg = TableExportCsvCommand.access$000().getString("TableExportCsvCommand.missingClobDataMsg", ClobDescriptor.i18n.CLOB_LABEL);
    }
}

