/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ProcedureInfo
extends DatabaseObjectInfo
implements IProcedureInfo {
    static final long serialVersionUID = -4111528608716386156L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProcedureInfo.class);
    private final int _procType;
    private final String _remarks;

    public ProcedureInfo(String catalog, String schema, String simpleName, String remarks, int procType, SQLDatabaseMetaData md) {
        super(catalog, schema, simpleName, DatabaseObjectType.PROCEDURE, md);
        this._remarks = remarks;
        this._procType = procType;
    }

    @Override
    public int getProcedureType() {
        return this._procType;
    }

    @Override
    public String getRemarks() {
        return this._remarks;
    }

    @Override
    public String getProcedureTypeDescription() {
        switch (this._procType) {
            case 1: {
                return IStrings.DOESNT_RETURN;
            }
            case 2: {
                return IStrings.DOES_RETURN;
            }
            case 0: {
                return IStrings.MAY_RETURN;
            }
        }
        return IStrings.UNKNOWN;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof ProcedureInfo) {
            ProcedureInfo info = (ProcedureInfo)obj;
            if (info._remarks == null && this._remarks == null || info._remarks != null && this._remarks != null && info._remarks.equals(this._remarks)) {
                return info._procType == this._procType;
            }
        }
        return false;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface IStrings {
        public static final String DATABASE = ProcedureInfo.access$000().getString("ProcedureInfo.database");
        public static final String MAY_RETURN = ProcedureInfo.access$000().getString("ProcedureInfo.mayreturn");
        public static final String DOESNT_RETURN = ProcedureInfo.access$000().getString("ProcedureInfo.doesntreturn");
        public static final String DOES_RETURN = ProcedureInfo.access$000().getString("ProcedureInfo.returns");
        public static final String UNKNOWN = ProcedureInfo.access$000().getString("ProcedureInfo.unknown");
    }
}

