/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.ISessionProperties;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLConnectionState {
    private static final ILogger s_log = LoggerController.createLogger(SQLConnectionState.class);
    private Integer _transIsolation;
    private String _catalog;
    private boolean _autoCommit;
    private SQLDriverPropertyCollection _connProps;

    public void saveState(ISQLConnection conn, ISessionProperties sessionProperties, IMessageHandler msgHandler) throws SQLException {
        String msg;
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        try {
            this._transIsolation = conn.getTransactionIsolation();
        }
        catch (SQLException ex) {
            msg = "Error saving transaction isolation.\nThis might happen when reconnecting a Session to restore a broken connection.\nThe new connection will use the default transaction isolation.";
            s_log.error(msg, ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(msg);
        }
        try {
            this._catalog = conn.getCatalog();
        }
        catch (SQLException ex) {
            msg = "Error saving current catalog.\nThis might happen when reconnecting a Session to restore a broken connection.\nThe new connection will use the default catalog.";
            s_log.error(msg, ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(msg);
        }
        try {
            this._autoCommit = sessionProperties.getAutoCommit();
            this._autoCommit = conn.getAutoCommit();
        }
        catch (SQLException ex) {
            msg = "Error saving autocommit state.\nThis might happen when reconnecting a Session to restore a broken connection.\nThe new connection will use the autocommit state.";
            s_log.error(msg, ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(msg);
        }
        this._connProps = conn.getConnectionProperties();
    }

    public void restoreState(ISQLConnection conn) throws SQLException {
        this.restoreState(conn, null);
    }

    public void restoreState(ISQLConnection conn, IMessageHandler msgHandler) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        if (this._transIsolation != null) {
            try {
                conn.setTransactionIsolation(this._transIsolation);
            }
            catch (SQLException ex) {
                s_log.error("Error restoring transaction isolation", ex);
                if (msgHandler == null) {
                    throw ex;
                }
                msgHandler.showErrorMessage(ex, null);
            }
        }
        if (this._catalog != null) {
            try {
                conn.setCatalog(this._catalog);
            }
            catch (SQLException ex) {
                s_log.error("Error restoring current catalog", ex);
                if (msgHandler == null) {
                    throw ex;
                }
                msgHandler.showErrorMessage(ex, null);
            }
        }
        try {
            conn.setAutoCommit(this._autoCommit);
        }
        catch (SQLException ex) {
            s_log.error("Error restoring autocommit", ex);
            if (msgHandler == null) {
                throw ex;
            }
            msgHandler.showErrorMessage(ex, null);
        }
    }

    public SQLDriverPropertyCollection getConnectionProperties() {
        return this._connProps;
    }

    public boolean getAutoCommit() {
        return this._autoCommit;
    }
}

