/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class Resources {
    public static final String ACCELERATOR_STRING = "SQuirreLAcceleratorString";
    private static final ILogger s_log = LoggerController.createLogger(Resources.class);
    private final ResourceBundle _bundle;
    private ClassLoader _classLoader;
    private final String _imagePath;

    protected Resources(String rsrcBundleBaseName, ClassLoader cl) {
        if (rsrcBundleBaseName == null || rsrcBundleBaseName.trim().length() == 0) {
            throw new IllegalArgumentException("Null or empty rsrcBundleBaseName passed");
        }
        this._classLoader = cl;
        this._bundle = ResourceBundle.getBundle(rsrcBundleBaseName, Locale.getDefault(), cl);
        this._imagePath = this._bundle.getString("path.images");
    }

    public KeyStroke getKeyStroke(Action action) {
        Utilities.checkNull("getKeyStroke", "action", action);
        String fullKey = "menuitem." + action.getClass().getName();
        String accel = this.getResourceString(fullKey, "accelerator");
        if (accel.length() > 0) {
            return KeyStroke.getKeyStroke(accel);
        }
        return null;
    }

    private String getAcceleratorString(Action action) {
        try {
            String fullKey = "menuitem." + action.getClass().getName();
            return this.getResourceString(fullKey, "accelerator");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public JMenuItem addToPopupMenu(Action action, JPopupMenu menu) throws MissingResourceException {
        String accel;
        String mn;
        Utilities.checkNull("addToPopupMenu", "action", action, "menu", menu);
        String fullKey = "menuitem." + action.getClass().getName();
        JMenuItem item = menu.add(action);
        if (action.getValue("MnemonicKey") == null && (mn = this.getResourceString(fullKey, "mnemonic")).length() > 0) {
            item.setMnemonic(mn.charAt(0));
        }
        if (action.getValue("AcceleratorKey") == null && (accel = this.getResourceString(fullKey, "accelerator")).length() > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(accel));
        }
        String toolTipText = this.getToolTipTextWithAccelerator(action, fullKey);
        item.setToolTipText(toolTipText);
        return item;
    }

    public JCheckBoxMenuItem addToMenuAsCheckBoxMenuItem(Action action, JMenu menu) throws MissingResourceException {
        Utilities.checkNull("addToMenuAsCheckBoxMenuItem", "action", action, "menu", menu);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.configureMenuItem(action, item);
        return item;
    }

    public JCheckBoxMenuItem addToMenuAsCheckBoxMenuItem(Action action, JPopupMenu popupMenu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        popupMenu.add(item);
        this.configureMenuItem(action, item);
        return item;
    }

    public JMenuItem addToMenu(Action action, JMenu menu) throws MissingResourceException {
        JMenuItem item = menu.add(action);
        this.configureMenuItem(action, item);
        return item;
    }

    public JMenu createMenu(String menuKey) throws MissingResourceException {
        JMenu menu = new JMenu();
        String fullKey = "menu." + menuKey;
        menu.setText(this.getResourceString(fullKey, "title"));
        String mn = this.getResourceString(fullKey, "mnemonic");
        if (mn.length() >= 1) {
            menu.setMnemonic(mn.charAt(0));
        }
        return menu;
    }

    public void setupAction(Action action, boolean showColoricons) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        String actionClassName = action.getClass().getName();
        String key = "action." + actionClassName;
        action.putValue("Name", this.getResourceString(key, "name"));
        String shortDescription = this.getResourceString(key, "tooltip");
        String acceleratorString = this.getAcceleratorString(action);
        if (null != acceleratorString && 0 < acceleratorString.trim().length()) {
            shortDescription = shortDescription + "  (" + acceleratorString + ")";
        }
        action.putValue("ShortDescription", shortDescription);
        String accelerator = this.getAcceleratorString(action);
        if (null != accelerator) {
            action.putValue(ACCELERATOR_STRING, accelerator);
        }
        ImageIcon icon = null;
        try {
            if (showColoricons) {
                icon = this.getIcon(key, "rolloverimage");
                action.putValue("SmallIcon", icon);
            } else {
                icon = this.getIcon(key, "image");
                action.putValue("SmallIcon", icon);
            }
        }
        catch (MissingResourceException ex) {
            try {
                icon = this.getIcon(key, "image");
                action.putValue("SmallIcon", icon);
            }
            catch (MissingResourceException ignore) {
                // empty catch block
            }
        }
        try {
            icon = this.getIcon(key, "rolloverimage");
            action.putValue("squirrelRolloverIcon", icon);
        }
        catch (MissingResourceException ignore) {
            // empty catch block
        }
        try {
            icon = this.getIcon(key, "disabledimage");
            action.putValue("squirrelDisabledIcon", icon);
        }
        catch (MissingResourceException ignore) {
            // empty catch block
        }
    }

    public ImageIcon getIcon(String keyName) {
        return this.getIcon(keyName, "image");
    }

    public ImageIcon getIcon(Class<?> objClass, String propName) {
        return this.getIcon(objClass.getName(), propName);
    }

    public ImageIcon getIcon(String keyName, String propName) {
        if (keyName == null) {
            throw new IllegalArgumentException("keyName == null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("propName == null");
        }
        ImageIcon icon = null;
        String rsrcName = this.getResourceString(keyName, propName);
        if (rsrcName != null && rsrcName.length() > 0) {
            icon = this.privateGetIcon(rsrcName);
            if (icon == null) {
                s_log.error("can't load image: " + rsrcName);
            }
        } else if (s_log.isDebugEnabled()) {
            s_log.debug("No resource found for " + keyName + " : " + propName);
        }
        return icon;
    }

    public String getString(String key) {
        Utilities.checkNull("getString", "key", key);
        return this._bundle.getString(key);
    }

    public void configureMenuItem(Action action, JMenuItem item) throws MissingResourceException {
        String accel;
        String mn;
        Utilities.checkNull("configureMenuItem", "action", action, "item", item);
        String fullKey = "menuitem." + action.getClass().getName();
        if (action.getValue("MnemonicKey") == null && (mn = this.getResourceString(fullKey, "mnemonic")).length() > 0) {
            item.setMnemonic(mn.charAt(0));
        }
        if (action.getValue("AcceleratorKey") == null && (accel = this.getResourceString(fullKey, "accelerator")).length() > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(accel));
        }
        String toolTipText = this.getToolTipTextWithAccelerator(action, fullKey);
        item.setToolTipText(toolTipText);
    }

    private String getToolTipTextWithAccelerator(Action action, String fullKey) {
        String toolTipText = (String)action.getValue("ShortDescription");
        if (null == toolTipText) {
            toolTipText = "";
        }
        try {
            String accel = this.getResourceString(fullKey, "accelerator");
            if (null != accel && accel.length() > 0) {
                toolTipText = toolTipText + "  (" + accel + ")";
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return toolTipText;
    }

    protected ResourceBundle getBundle() {
        return this._bundle;
    }

    private ImageIcon privateGetIcon(String iconName) {
        if (iconName != null && iconName.length() > 0) {
            URL url;
            String imagePathName = this.getImagePathName(iconName);
            if (null == this._classLoader) {
                url = this.getClass().getResource(imagePathName);
                if (null == url && imagePathName.startsWith("/")) {
                    url = this.getClass().getResource(imagePathName.substring(1));
                } else if (null == url && !imagePathName.startsWith("/")) {
                    url = this.getClass().getResource("/" + imagePathName);
                }
            } else {
                url = this._classLoader.getResource(imagePathName);
                if (null == url && imagePathName.startsWith("/")) {
                    url = this._classLoader.getResource(imagePathName.substring(1));
                } else if (null == url && !imagePathName.startsWith("/")) {
                    url = this._classLoader.getResource("/" + imagePathName);
                }
            }
            if (url != null) {
                return new ImageIcon(url);
            }
        }
        return null;
    }

    private String getResourceString(String keyName, String propName) throws MissingResourceException {
        return this._bundle.getString(keyName + "." + propName);
    }

    private String getImagePathName(String iconName) {
        return this._imagePath + iconName;
    }

    private static interface Keys {
        public static final String ACTION = "action";
        public static final String MENU = "menu";
        public static final String MENU_ITEM = "menuitem";
    }

    private static interface MenuItemProperties
    extends MenuProperties {
        public static final String ACCELERATOR = "accelerator";
    }

    private static interface MenuProperties {
        public static final String TITLE = "title";
        public static final String MNEMONIC = "mnemonic";
    }

    private static interface ActionProperties {
        public static final String DISABLED_IMAGE = "disabledimage";
        public static final String IMAGE = "image";
        public static final String NAME = "name";
        public static final String ROLLOVER_IMAGE = "rolloverimage";
        public static final String TOOLTIP = "tooltip";
    }
}

