/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.xml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import net.sourceforge.squirrel_sql.fw.util.beanwrapper.StringWrapper;
import net.sourceforge.squirrel_sql.fw.xml.IXMLAboutToBeWritten;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;

public final class XMLBeanWriter {
    private IXMLElement _rootElement = new XMLElement("Beans");

    public XMLBeanWriter() throws XMLException {
        this(null);
    }

    public XMLBeanWriter(Object bean) throws XMLException {
        if (bean != null) {
            this.addToRoot(bean);
        }
    }

    public void addIteratorToRoot(Iterator it) throws XMLException {
        while (it.hasNext()) {
            this.addToRoot(it.next());
        }
    }

    public void addToRoot(Object bean) throws XMLException {
        try {
            this._rootElement.addChild(this.createElement(bean, null));
        }
        catch (Exception ex) {
            throw new XMLException(ex);
        }
    }

    public void save(String fileName) throws IOException {
        this.save(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            XMLWriter wtr = new XMLWriter((OutputStream)os);
            wtr.write(this._rootElement, true);
        }
        finally {
            os.close();
        }
    }

    private IXMLElement createElement(Object bean, String name) throws XMLException {
        XMLElement elem = null;
        BeanInfo info = null;
        try {
            if (bean != null) {
                info = Introspector.getBeanInfo(bean.getClass(), Object.class);
            }
        }
        catch (IntrospectionException ex) {
            throw new XMLException(ex);
        }
        elem = new XMLElement(name != null ? name : "Bean");
        if (info != null) {
            if (bean instanceof IXMLAboutToBeWritten) {
                ((IXMLAboutToBeWritten)bean).aboutToBeWritten();
            }
            PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
            elem = new XMLElement(name != null ? name : "Bean");
            elem.setAttribute("Class", bean.getClass().getName());
            for (int i = 0; i < propDesc.length; ++i) {
                this.processProperty(propDesc[i], bean, (IXMLElement)elem);
            }
        }
        return elem;
    }

    private void processProperty(PropertyDescriptor propDescr, Object bean, IXMLElement beanElem) throws XMLException {
        Method getter = propDescr.getReadMethod();
        if (getter != null) {
            try {
                String propName = propDescr.getName();
                Class<?> returnType = getter.getReturnType();
                if (returnType.isArray()) {
                    boolean isStringArray = returnType.getName().equals("[Ljava.lang.String;");
                    Object[] props = (Object[])getter.invoke(bean, (Object[])null);
                    if (props != null) {
                        XMLElement indexElem = new XMLElement(propName);
                        indexElem.setAttribute("Indexed", "true");
                        beanElem.addChild((IXMLElement)indexElem);
                        for (int i = 0; i < props.length; ++i) {
                            if (isStringArray) {
                                StringWrapper sw = new StringWrapper((String)props[i]);
                                indexElem.addChild(this.createElement(sw, "Bean"));
                                continue;
                            }
                            indexElem.addChild(this.createElement(props[i], "Bean"));
                        }
                    }
                } else if (returnType == Boolean.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Long.TYPE || returnType == Float.TYPE || returnType == Double.TYPE || returnType == Character.TYPE) {
                    XMLElement propElem = new XMLElement(propName);
                    propElem.setContent("" + getter.invoke(bean, (Object[])null));
                    beanElem.addChild((IXMLElement)propElem);
                } else if (returnType == String.class) {
                    XMLElement propElem = new XMLElement(propName);
                    propElem.setContent((String)getter.invoke(bean, (Object[])null));
                    beanElem.addChild((IXMLElement)propElem);
                } else {
                    beanElem.addChild(this.createElement(getter.invoke(bean, (Object[])null), propName));
                }
            }
            catch (Exception ex) {
                throw new XMLException(ex);
            }
        }
    }
}

