/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.util.Iterator;
import java.util.Map;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;

public class MapDataSet
implements IDataSet {
    private static final int s_columnCount = 2;
    private static final String[] s_hdgs = new String[]{"Key", "Value"};
    private final Map _src;
    private DataSetDefinition _dsDef;
    private static final int[] s_hdgLens = new int[]{30, 100};
    private Iterator _rowKeys;
    private Object[] _curRow = new Object[2];

    public MapDataSet(Map src) throws DataSetException {
        if (src == null) {
            throw new IllegalArgumentException("Map == null");
        }
        this._src = src;
        this._dsDef = new DataSetDefinition(this.createColumnDefinitions());
        this._rowKeys = this._src.keySet().iterator();
    }

    public final int getColumnCount() {
        return 2;
    }

    public DataSetDefinition getDataSetDefinition() {
        return this._dsDef;
    }

    public synchronized boolean next(IMessageHandler msgHandler) {
        this._curRow[0] = null;
        this._curRow[1] = null;
        if (this._rowKeys.hasNext()) {
            this._curRow[0] = this._rowKeys.next();
        }
        if (this._curRow[0] != null) {
            this._curRow[1] = this._src.get(this._curRow[0]);
        }
        return this._curRow[0] != null;
    }

    public Object get(int columnIndex) {
        return this._curRow[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        int columnCount = this.getColumnCount();
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnDefs[i] = new ColumnDisplayDefinition(s_hdgLens[i], s_hdgs[i]);
        }
        return columnDefs;
    }

    private static interface i18n {
        public static final String UNSUPPORTED = "<Unsupported>";
        public static final String NAME_COLUMN = "Key";
        public static final String VALUE_COLUMN = "Value";
    }
}

