/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class MemoryPanel
extends JLabel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$gui$MemoryPanel == null ? (class$net$sourceforge$squirrel_sql$fw$gui$MemoryPanel = MemoryPanel.class$("net.sourceforge.squirrel_sql.fw.gui.MemoryPanel")) : class$net$sourceforge$squirrel_sql$fw$gui$MemoryPanel);
    private Timer _timer;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$gui$MemoryPanel;

    public MemoryPanel() {
        super("", 0);
    }

    public void addNotify() {
        super.addNotify();
        this.updateMemoryStatus();
        ToolTipManager.sharedInstance().registerComponent(this);
        this._timer = new Timer(2000, new TimerListener());
        this._timer.start();
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public String getToolTipText() {
        Runtime rt = Runtime.getRuntime();
        long totalMemory = rt.totalMemory();
        long freeMemory = rt.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        Object[] args = new Object[]{Utilities.formatSize(usedMemory), Utilities.formatSize(totalMemory), Utilities.formatSize(freeMemory)};
        return s_stringMgr.getString("MemoryPanel.message", args);
    }

    public Dimension getPreferredSize() {
        Insets ins;
        Dimension dim = super.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        dim.width = fm.stringWidth("99.9MB/99.9MB");
        Border border = this.getBorder();
        if (border != null && (ins = border.getBorderInsets(this)) != null) {
            dim.width += ins.left + ins.right;
        }
        if ((ins = this.getInsets()) != null) {
            dim.width += ins.left + ins.right;
        }
        return dim;
    }

    private void updateMemoryStatus() {
        Runtime rt = Runtime.getRuntime();
        long totalMemory = rt.totalMemory();
        long freeMemory = rt.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        StringBuffer buf = new StringBuffer();
        buf.append(Utilities.formatSize(usedMemory, 1)).append("/").append(Utilities.formatSize(totalMemory, 1));
        this.setText(buf.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            MemoryPanel.this.updateMemoryStatus();
        }
    }
}

