/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.util.ArrayList;

public class StringUtilities {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean areStringsEqual(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null) {
            return str1.equals(str2);
        }
        return str2.equals(str1);
    }

    public static String cleanString(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        char prevCh = ' ';
        int limit = str.length();
        for (int i = 0; i < limit; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (!Character.isWhitespace(prevCh)) {
                    buf.append(' ');
                }
            } else {
                buf.append(ch);
            }
            prevCh = ch;
        }
        return buf.toString();
    }

    public static int countOccurences(String str, int ch) {
        if (StringUtilities.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        int idx = -1;
        do {
            ++idx;
            if ((idx = str.indexOf(ch, idx)) == -1) continue;
            ++count;
        } while (idx != -1);
        return count;
    }

    public static String[] split(String str, char delimiter) {
        return StringUtilities.split(str, delimiter, false);
    }

    public static String[] split(String str, char delimiter, boolean removeEmpty) {
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        String elem = null;
        int i = 0;
        int j = 0;
        while (j != -1 && j < len) {
            j = str.indexOf(delimiter, i);
            elem = j != -1 ? str.substring(i, j) : str.substring(i);
            i = j + 1;
            if (removeEmpty && (elem == null || elem.length() == 0)) continue;
            result.add(elem);
        }
        return result.toArray(new String[result.size()]);
    }
}

