/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.MaintenanceManager;

public class FBMaintenanceManager
extends FBServiceManager
implements MaintenanceManager {
    public FBMaintenanceManager() {
    }

    public FBMaintenanceManager(String gdsType) {
        super(gdsType);
    }

    public FBMaintenanceManager(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void setDatabaseAccessMode(int mode) throws SQLException {
        if (mode != 40 && mode != 39) {
            throw new IllegalArgumentException("mode must be one of ACCESS_MODE_READ_WRITE or ACCESS_MODE_READ_ONLY");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(13, (byte)mode);
        this.executeServicesOperation(srb);
    }

    @Override
    public void setDatabaseDialect(int dialect) throws SQLException {
        if (dialect != 1 && dialect != 3) {
            throw new IllegalArgumentException("dialect must be either 1 or 3");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(14, dialect);
        this.executeServicesOperation(srb);
    }

    @Override
    public void setDefaultCacheBuffer(int pageCount) throws SQLException {
        if (pageCount < 1) {
            throw new IllegalArgumentException("page count must be positive");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(5, pageCount);
        this.executeServicesOperation(srb);
    }

    @Override
    public void setForcedWrites(boolean forced) throws SQLException {
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(12, (byte)(forced ? 38 : 37));
        this.executeServicesOperation(srb);
    }

    @Override
    public void setPageFill(int pageFill) throws Exception {
        if (pageFill != 35 && pageFill != 36) {
            throw new IllegalArgumentException("Page fill must be either PAGE_FILL_FULL or PAGE_FILL_RESERVE");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(11, (byte)pageFill);
        this.executeServicesOperation(srb);
    }

    @Override
    public void shutdownDatabase(int shutdownMode, int timeout) throws SQLException {
        if (shutdownMode != 9 && shutdownMode != 10 && shutdownMode != 7) {
            throw new IllegalArgumentException("Shutdown mode must be one of: SHUTDOWN_ATTACH, SHUTDOWN_TRANSACTIONAL, SHUTDOWN_FORCE");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(shutdownMode, timeout);
        this.executeServicesOperation(srb);
    }

    @Override
    public void bringDatabaseOnline() throws SQLException {
        this.executePropertiesOperation(512);
    }

    @Override
    public void markCorruptRecords() throws SQLException {
        this.executeRepairOperation(4);
    }

    @Override
    public void validateDatabase() throws SQLException {
        this.executeRepairOperation(1);
    }

    @Override
    public void validateDatabase(int options) throws SQLException {
        if (options < 0 || options != 0 && options != 32 && (options & 0xFFFFFFDF) != 16 && (options & 0xFFFFFFDF) != 128 && (options | 0x30) != options && (options | 0xA0) != options) {
            throw new IllegalArgumentException("options must be either 0, VALIDATE_READ_ONLY, or VALIDATE_FULL, optionally combined with VALIDATE_IGNORE_CHECKSUM");
        }
        ServiceRequestBuffer srb = this.createRepairSRB(options | 1);
        this.executeServicesOperation(srb);
    }

    @Override
    public void setSweepThreshold(int transactions) throws SQLException {
        if (transactions < 0) {
            throw new IllegalArgumentException("transactions must be >= 0");
        }
        ServiceRequestBuffer srb = this.createDefaultPropertiesSRB();
        srb.addArgument(6, transactions);
        this.executeServicesOperation(srb);
    }

    @Override
    public void sweepDatabase() throws SQLException {
        this.executeRepairOperation(2);
    }

    @Override
    public void activateShadowFile() throws SQLException {
        this.executePropertiesOperation(256);
    }

    @Override
    public void killUnavailableShadows() throws SQLException {
        this.executeRepairOperation(64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listLimboTransactions() throws SQLException {
        OutputStream saveOut = this.getLogger();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(saveOut);
            this.setLogger(out);
            this.executeRepairOperation(8);
            byte[] output = out.toByteArray();
            int trId = 0;
            int shift = 0;
            for (int i = 0; i < output.length; ++i) {
                if (output[i] == 19) {
                    trId = 0;
                    shift = 0;
                    continue;
                }
                if (output[i] == 0 && shift != -1) {
                    ps.print(trId + "\n");
                    shift = -1;
                    continue;
                }
                if (shift == -1) continue;
                trId += (output[i] & 0xFF) << shift;
                shift += 8;
            }
        }
        finally {
            this.setLogger(saveOut);
        }
    }

    public int[] getLimboTransactions() throws SQLException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        this.setLogger(byteOut);
        this.listLimboTransactions();
        StringTokenizer limboTransactions = new StringTokenizer(byteOut.toString(), "\n");
        int[] trans = new int[limboTransactions.countTokens()];
        int count = 0;
        while (limboTransactions.hasMoreTokens()) {
            trans[count++] = Integer.parseInt(limboTransactions.nextToken().trim());
        }
        return trans;
    }

    @Override
    public void commitTransaction(int transactionId) throws SQLException {
        ServiceRequestBuffer srb = this.createDefaultRepairSRB();
        srb.addArgument(15, transactionId);
        this.executeServicesOperation(srb);
    }

    @Override
    public void rollbackTransaction(int transactionId) throws SQLException {
        ServiceRequestBuffer srb = this.createDefaultRepairSRB();
        srb.addArgument(34, transactionId);
        this.executeServicesOperation(srb);
    }

    private void executeRepairOperation(int operation) throws SQLException {
        ServiceRequestBuffer srb = this.createRepairSRB(operation);
        this.executeServicesOperation(srb);
    }

    private void executePropertiesOperation(int operation) throws SQLException {
        ServiceRequestBuffer srb = this.createPropertiesSRB(operation);
        this.executeServicesOperation(srb);
    }

    private ServiceRequestBuffer createDefaultPropertiesSRB() {
        return this.createPropertiesSRB(0);
    }

    private ServiceRequestBuffer createDefaultRepairSRB() {
        return this.createRepairSRB(0);
    }

    private ServiceRequestBuffer createPropertiesSRB(int options) {
        return this.createRequestBuffer(8, options);
    }

    private ServiceRequestBuffer createRepairSRB(int options) {
        return this.createRequestBuffer(3, options);
    }
}

