/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.service;

import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponent;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReloadableService<T>
extends AbstractIdentifiableInitializableComponent
implements ReloadableService<T>,
UnmodifiableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractReloadableService.class);
    @Duration
    private long reloadCheckDelay = 0L;
    @Nullable
    private Timer reloadTaskTimer;
    @Nullable
    private Timer internalTaskTimer;
    @Nullable
    private ServiceReloadTask reloadTask;
    @Nullable
    private DateTime lastReloadInstant;
    @Nullable
    private DateTime lastSuccessfulReleaseInstant;
    @Nullable
    private Throwable reloadFailureCause;
    private boolean failFast;
    @Nullable
    private String logPrefix;

    public long getReloadCheckDelay() {
        return this.reloadCheckDelay;
    }

    public void setReloadCheckDelay(@Duration long delay) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.reloadCheckDelay = delay;
    }

    @Nullable
    public Timer getReloadTaskTimer() {
        return this.reloadTaskTimer;
    }

    public void setReloadTaskTimer(@Nullable Timer timer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.reloadTaskTimer = timer;
    }

    @Override
    @Nullable
    public DateTime getLastReloadAttemptInstant() {
        return this.lastReloadInstant;
    }

    @Override
    @Nullable
    public DateTime getLastSuccessfulReloadInstant() {
        return this.lastSuccessfulReleaseInstant;
    }

    @Override
    @Nullable
    public Throwable getReloadFailureCause() {
        return this.reloadFailureCause;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean value) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.failFast = value;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.log.info("{} Performing initial load", (Object)this.getLogPrefix());
        try {
            this.lastReloadInstant = new DateTime((Chronology)ISOChronology.getInstanceUTC());
            this.doReload();
            this.lastSuccessfulReleaseInstant = this.lastReloadInstant;
        }
        catch (ServiceException e) {
            if (this.isFailFast()) {
                throw new ComponentInitializationException(this.getLogPrefix() + " could not perform initial load", e);
            }
            this.log.error("{} Initial load failed", (Object)this.getLogPrefix(), (Object)e);
            if (this.reloadCheckDelay > 0L) {
                this.log.info("{} Continuing to poll configuration", (Object)this.getLogPrefix());
            } else {
                this.log.error("{} No further attempts will be made to reload", (Object)this.getLogPrefix());
            }
        }
        catch (Exception e) {
            this.log.error("{} Unexpected error during initial load {}", (Object)this.getLogPrefix(), (Object)e);
            throw new ComponentInitializationException(this.getLogPrefix() + " Unexpected error during initial load", e);
        }
        if (this.reloadCheckDelay > 0L) {
            if (null == this.reloadTaskTimer) {
                this.log.debug("{} No reload task timer specified, creating default", (Object)this.getLogPrefix());
                this.internalTaskTimer = new Timer("Timer for " + this.getId(), true);
            } else {
                this.internalTaskTimer = this.reloadTaskTimer;
            }
            this.log.info("{} Reload time set to: {}, starting refresh thread", (Object)this.getLogPrefix(), (Object)this.reloadCheckDelay);
            this.reloadTask = new ServiceReloadTask();
            this.internalTaskTimer.schedule((TimerTask)this.reloadTask, this.reloadCheckDelay, this.reloadCheckDelay);
        }
    }

    @Override
    protected void doDestroy() {
        this.log.info("{} Starting shutdown", (Object)this.getLogPrefix());
        if (this.reloadTask != null) {
            this.reloadTask.cancel();
            this.reloadTask = null;
        }
        if (this.reloadTaskTimer == null && this.internalTaskTimer != null) {
            this.internalTaskTimer.cancel();
        }
        this.internalTaskTimer = null;
        this.log.info("{} Completing shutdown", (Object)this.getLogPrefix());
        super.doDestroy();
    }

    @Override
    public final void reload() {
        DateTime now;
        this.lastReloadInstant = now = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        try {
            this.doReload();
            this.lastSuccessfulReleaseInstant = now;
            this.reloadFailureCause = null;
        }
        catch (ServiceException e) {
            this.log.error("{} Reload for {} failed", new Object[]{this.getLogPrefix(), this.getId(), e});
            this.reloadFailureCause = e;
            throw e;
        }
    }

    protected abstract boolean shouldReload();

    protected void doReload() {
        this.log.info("{} Reloading service configuration", (Object)this.getLogPrefix());
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Service '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }

    protected class ServiceReloadTask
    extends TimerTask {
        protected ServiceReloadTask() {
        }

        @Override
        public void run() {
            if (AbstractReloadableService.this.shouldReload()) {
                try {
                    AbstractReloadableService.this.reload();
                }
                catch (ServiceException se) {
                    AbstractReloadableService.this.log.debug("{} Previously logged error during reload", (Object)AbstractReloadableService.this.getLogPrefix(), (Object)se);
                }
                catch (Throwable t) {
                    AbstractReloadableService.this.log.warn("{} Unexpected error during reload", (Object)AbstractReloadableService.this.getLogPrefix(), (Object)t);
                }
            }
        }
    }
}

