/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.extra.internal.misc;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class UuidUtils {
    public static UUID uuid3(UUID namespace, byte[] name) {
        return UuidUtils.uuid3or5(namespace, name, 3);
    }

    public static UUID uuid5(UUID namespace, byte[] name) {
        return UuidUtils.uuid3or5(namespace, name, 5);
    }

    public static UUID uuid3or5(UUID namespace, byte[] name, int version) {
        MessageDigest md;
        try {
            switch (version) {
                case 3: {
                    md = MessageDigest.getInstance("MD5");
                    break;
                }
                case 5: {
                    md = MessageDigest.getInstance("SHA-1");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid version");
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(UuidUtils.toBytes(namespace));
        md.update(name);
        byte[] hash = md.digest();
        hash[6] = (byte)(hash[6] & 0xF);
        hash[6] = (byte)(hash[6] | (byte)(version << 4));
        hash[8] = (byte)(hash[8] & 0x3F);
        hash[8] = (byte)(hash[8] | 0xFFFFFF80);
        return UuidUtils.fromBytes(hash);
    }

    public static byte[] toBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static UUID fromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long mostSigBits = bb.getLong();
        long leastSigBits = bb.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }
}

