/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.IllegalJsonInputException;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"@sh/0"})
@AutoService(value={Function.class})
public class AtShFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        if (in.isArray()) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (JsonNode i : in) {
                if (i.isTextual()) {
                    tokens.add(this.escape(i.asText()));
                    continue;
                }
                if (i.isValueNode()) {
                    tokens.add(AtShFunction.toString(scope, i));
                    continue;
                }
                throw new IllegalJsonInputException(i.getNodeType() + " cannot be escaped for shell");
            }
            output.emit((JsonNode)new TextNode(Strings.join(" ", tokens)), null);
        } else if (in.isTextual()) {
            output.emit((JsonNode)new TextNode(this.escape(in.asText())), null);
        } else if (in.isValueNode()) {
            output.emit((JsonNode)new TextNode(AtShFunction.toString(scope, in)), null);
        } else {
            throw new IllegalJsonInputException(in.getNodeType() + " cannot be escaped for shell");
        }
    }

    private static String toString(Scope scope, JsonNode node) throws JsonQueryException {
        try {
            return scope.getObjectMapper().writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new JsonQueryException(e);
        }
    }

    public String escape(String text) {
        StringBuilder builder = new StringBuilder("'");
        block4: for (char ch : text.toCharArray()) {
            switch (ch) {
                case '\'': {
                    builder.append("'\\''");
                    continue block4;
                }
                case '\u0000': {
                    builder.append("\\0");
                    continue block4;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        builder.append("'");
        return builder.toString();
    }
}

