/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.crud;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import net.tirasa.adsddl.ntsd.SID;
import net.tirasa.adsddl.ntsd.utils.Hex;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.util.ADGuardedPasswordAttribute;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.GroupHelper;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.LdapEntry;
import net.tirasa.connid.bundles.ldap.commons.LdapModifyOperation;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class ADUpdate
extends LdapModifyOperation {
    private static final Log LOG = Log.getLog(ADUpdate.class);
    private final ObjectClass oclass;
    private final Uid uid;
    private final ADUtilities utils;
    private final ADConnection conn;

    private Name getNewName(String entryDN, Set<Attribute> attrs) {
        Attribute cnAttr = AttributeUtil.find((String)"CN", attrs);
        if (cnAttr != null) {
            attrs.remove(cnAttr);
        }
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        Name newName = null;
        if (name != null) {
            attrs.remove(name);
            if (ADUtilities.isDN(name.getNameValue())) {
                newName = new Name(this.conn.getSchemaMapping().getEntryDN(this.oclass, name));
            }
        }
        if (newName == null && !this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass).equalsIgnoreCase("CN") && cnAttr != null) {
            String cnValue = cnAttr.getValue() == null || cnAttr.getValue().isEmpty() || cnAttr.getValue().get(0) == null ? null : cnAttr.getValue().get(0).toString();
            try {
                ArrayList<Rdn> rdns = new ArrayList<Rdn>(new LdapName(entryDN).getRdns());
                Rdn naming = new Rdn(((Rdn)rdns.get(rdns.size() - 1)).getType(), cnValue);
                rdns.remove(rdns.size() - 1);
                rdns.add(naming);
                newName = new Name(new LdapName(rdns).toString());
            }
            catch (InvalidNameException e) {
                LOG.error("Error retrieving new DN. Ignore rename request.", new Object[]{e});
            }
        }
        return newName;
    }

    public ADUpdate(ADConnection conn, ObjectClass oclass, Uid uid) {
        super((LdapConnection)conn);
        this.utils = new ADUtilities(conn);
        this.oclass = oclass;
        this.uid = uid;
        this.conn = conn;
    }

    public Uid update(Set<Attribute> attrs) {
        Set attrsToBeUpdated;
        ConnectorObject obj = this.utils.getEntryToBeUpdated(this.uid, this.oclass);
        String entryDN = obj.getName().getNameValue();
        Name newName = this.getNewName(entryDN, attrsToBeUpdated = CollectionUtil.newSet(attrs));
        if (newName != null && !newName.equals((Object)obj.getName())) {
            if (((ADConfiguration)((Object)ADConfiguration.class.cast(this.conn.getConfiguration()))).isExcludeAttributeChangesOnUpdate()) {
                LOG.error("Rename operation not permitted: '{0}' to '{1}'", new Object[]{entryDN, newName});
                throw new ConnectorException("Rename operation not permitted");
            }
            entryDN = this.conn.getSchemaMapping().rename(this.oclass, entryDN, newName);
        }
        if (((ADConfiguration)((Object)ADConfiguration.class.cast(this.conn.getConfiguration()))).isExcludeAttributeChangesOnUpdate()) {
            LOG.ok("Modify attributes not permitted, excludeAttributeChangesOnUpdate is enabled", new Object[0]);
        } else {
            Pair<Attributes, ADGuardedPasswordAttribute> attrToModify = this.getAttributesToModify(obj, attrsToBeUpdated);
            this.modifyAttributes(entryDN, attrToModify, 2);
        }
        this.modifyMemberships(entryDN, attrsToBeUpdated);
        this.modifyPrimaryGroupID(entryDN, attrsToBeUpdated);
        return this.conn.getSchemaMapping().createUid(this.oclass, entryDN);
    }

    public Uid addAttributeValues(Set<Attribute> attrs) {
        ConnectorObject obj = this.utils.getEntryToBeUpdated(this.uid, this.oclass);
        String entryDN = obj.getName().getNameValue();
        Pair<Attributes, ADGuardedPasswordAttribute> attrsToModify = this.getAttributesToModify(obj, attrs);
        this.modifyAttributes(entryDN, attrsToModify, 1);
        this.modifyMemberships(entryDN, attrs);
        this.modifyPrimaryGroupID(entryDN, attrs);
        return this.uid;
    }

    public Uid removeAttributeValues(Set<Attribute> attrs) {
        ConnectorObject obj = this.utils.getEntryToBeUpdated(this.uid, this.oclass);
        String entryDN = obj.getName().getNameValue();
        Pair<Attributes, ADGuardedPasswordAttribute> attrsToModify = this.getAttributesToModify(obj, attrs);
        this.modifyAttributes(entryDN, attrsToModify, 3);
        List<String> ldapGroups = this.getStringListValue(attrs, "ldapGroups");
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.removeLdapGroupMemberships(entryDN, ldapGroups);
        }
        return this.uid;
    }

    private Pair<Attributes, ADGuardedPasswordAttribute> getAttributesToModify(ConnectorObject obj, Set<Attribute> attrs) {
        BasicAttributes ldapAttrs = new BasicAttributes();
        ADGuardedPasswordAttribute pwdAttr = null;
        Attribute uac = obj.getAttributeByName("userAccountControl");
        int currentUACValue = uac == null || uac.getValue() == null || uac.getValue().isEmpty() ? 0 : Integer.parseInt(uac.getValue().get(0).toString());
        int newUACValue = -1;
        Boolean pne = null;
        Boolean status = null;
        for (Attribute attr : attrs) {
            List value;
            javax.naming.directory.Attribute ldapAttr = null;
            if (attr.is(Uid.NAME)) {
                throw new IllegalArgumentException("Unable to modify an object's uid");
            }
            if (attr.is(Name.NAME)) {
                throw new IllegalArgumentException("Unable to modify an object's name");
            }
            if (attr.is("userCannotChangePassword")) {
                javax.naming.directory.Attribute ntSecurityDescriptor;
                value = attr.getValue();
                if (value != null && !value.isEmpty() && (ntSecurityDescriptor = this.utils.userCannotChangePassword(obj, (Boolean)value.get(0))) != null) {
                    ldapAttrs.put(ntSecurityDescriptor);
                }
            } else if (attr.is("passwordNeverExpires")) {
                value = attr.getValue();
                if (value != null && !value.isEmpty()) {
                    pne = (Boolean)value.get(0);
                }
            } else if (attr.is("pwdLastSet")) {
                value = attr.getValue();
                if (value != null && !value.isEmpty()) {
                    Boolean enabled = (Boolean)value.get(0);
                    if (enabled.booleanValue()) {
                        ldapAttrs.put(new BasicAttribute("pwdLastSet", "0"));
                    } else {
                        ldapAttrs.put(new BasicAttribute("pwdLastSet", "-1"));
                    }
                }
            } else if (attr.is("lockoutTime")) {
                value = attr.getValue();
                if (value != null && !value.isEmpty() && ((Boolean)value.get(0)).booleanValue()) {
                    ldapAttrs.put(new BasicAttribute("lockoutTime", "0"));
                }
            } else if (!LdapConstants.isLdapGroups((String)attr.getName())) {
                if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                    pwdAttr = ADGuardedPasswordAttribute.create(this.conn.getConfiguration().getPasswordAttribute(), attr);
                } else if (attr.is("userAccountControl") && this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                    newUACValue = attr.getValue() == null || attr.getValue().isEmpty() ? -1 : Integer.parseInt(attr.getValue().get(0).toString());
                } else if (attr.is(OperationalAttributes.ENABLE_NAME) && this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                    status = attr.getValue() == null || attr.getValue().isEmpty() || Boolean.parseBoolean(attr.getValue().get(0).toString());
                } else if (!attr.is("objectGUID")) {
                    ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, attr);
                }
            }
            this.addAttribute(ldapAttr, ldapAttrs);
        }
        if (this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
            if (pne != null) {
                if ((currentUACValue & 0x10000) == 65536 && !pne.booleanValue()) {
                    newUACValue = currentUACValue - 65536;
                } else if ((currentUACValue & 0x10000) != 65536 && pne.booleanValue()) {
                    newUACValue = currentUACValue + 65536;
                }
            }
            if (status != null) {
                if ((currentUACValue & 2) == 2 && status.booleanValue()) {
                    newUACValue = currentUACValue - 2;
                } else if ((currentUACValue & 2) != 2 && !status.booleanValue()) {
                    newUACValue = currentUACValue + 2;
                }
            }
            if (newUACValue >= 0) {
                this.addAttribute(this.conn.getSchemaMapping().encodeAttribute(this.oclass, AttributeBuilder.build((String)"userAccountControl", (Object[])new Object[]{Integer.toString(newUACValue)})), ldapAttrs);
            }
        }
        return new Pair((Object)ldapAttrs, pwdAttr);
    }

    private void addAttribute(javax.naming.directory.Attribute ldapAttr, BasicAttributes ldapAttrs) {
        if (ldapAttr != null) {
            javax.naming.directory.Attribute existingAttr = ldapAttrs.get(ldapAttr.getID());
            if (existingAttr != null) {
                try {
                    NamingEnumeration<?> all = ldapAttr.getAll();
                    while (all.hasMoreElements()) {
                        existingAttr.add(all.nextElement());
                    }
                }
                catch (NamingException e) {
                    throw new ConnectorException((Throwable)e);
                }
            } else {
                ldapAttrs.put(ldapAttr);
            }
        }
    }

    private void modifyAttributes(final String entryDN, Pair<Attributes, ADGuardedPasswordAttribute> attrs, final int modifyOp) {
        final ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>(((Attributes)attrs.first).size());
        NamingEnumeration<? extends javax.naming.directory.Attribute> attrEnum = ((Attributes)attrs.first).getAll();
        while (attrEnum.hasMoreElements()) {
            javax.naming.directory.Attribute attr = (javax.naming.directory.Attribute)attrEnum.nextElement();
            if (attr.getID().equalsIgnoreCase("ldapGroups") || attr.getID().equalsIgnoreCase("primaryGroupDN")) continue;
            modItems.add(new ModificationItem(modifyOp, attr));
        }
        if (attrs.second != null) {
            ((ADGuardedPasswordAttribute)attrs.second).access(new ADGuardedPasswordAttribute.Accessor(){

                @Override
                public void access(BasicAttribute attr) {
                    try {
                        if (attr.get() != null) {
                            modItems.add(new ModificationItem(modifyOp, attr));
                            ADUpdate.this.modifyAttributes(entryDN, modItems);
                        }
                    }
                    catch (NamingException e) {
                        LOG.error((Throwable)e, "Error retrieving password value", new Object[0]);
                    }
                }
            });
        }
        this.modifyAttributes(entryDN, modItems);
    }

    private void modifyAttributes(String entryDN, List<ModificationItem> modItems) {
        try {
            this.conn.getInitialContext().modifyAttributes(entryDN, modItems.toArray(new ModificationItem[modItems.size()]));
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private List<String> getStringListValue(Set<Attribute> attrs, String attrName) {
        Attribute attr = AttributeUtil.find((String)attrName, attrs);
        if (attr != null && attr.getValue() != null) {
            return LdapUtil.checkedListByFilter((List)CollectionUtil.nullAsEmpty((List)attr.getValue()), String.class);
        }
        return null;
    }

    private void modifyPrimaryGroupID(String entryDN, Set<Attribute> attrs) {
        List<String> primaryGroupDN = this.getStringListValue(attrs, "primaryGroupDN");
        if (primaryGroupDN != null && !primaryGroupDN.isEmpty()) {
            try {
                this.conn.getInitialContext().modifyAttributes(entryDN, new ModificationItem[]{new ModificationItem(2, this.utils.getGroupID(primaryGroupDN.get(0)))});
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "Error setting primaryGroupID '{0}' for '{1}'", new Object[]{primaryGroupDN, entryDN});
            }
        }
    }

    private void modifyMemberships(String entryDN, Set<Attribute> attrs) {
        List<String> ldapGroups = this.getStringListValue(attrs, "ldapGroups");
        if (ldapGroups != null) {
            Set<String> currents = this.utils.getGroups(entryDN, ((ADConfiguration)this.conn.getConfiguration()).getBaseContextsToSynchronize());
            Set<String> oldMemberships = this.utils.getGroups(entryDN);
            String primaryGroup = null;
            LdapEntry profile = this.utils.getEntryToBeUpdated(entryDN);
            try {
                javax.naming.directory.Attribute primaryGroupID = profile.getAttributes().get("primaryGroupID");
                if (primaryGroupID != null && primaryGroupID.get() != null) {
                    javax.naming.directory.Attribute objectsid = profile.getAttributes().get("objectSID");
                    SID groupSID = ADUtilities.getPrimaryGroupSID(SID.parse((byte[])((byte[])objectsid.get())), NumberFacility.getUIntBytes((long)Long.parseLong(primaryGroupID.get().toString())));
                    Set<SearchResult> res = this.utils.basicLdapSearch(String.format("(&(objectclass=group)(%s=%s))", "objectSID", Hex.getEscaped((byte[])groupSID.toByteArray())), ((ADConfiguration)this.conn.getConfiguration()).getBaseContextsToSynchronize());
                    if (res == null || res.isEmpty()) {
                        LOG.warn("Error retrieving primary group for {0}", new Object[]{entryDN});
                    } else {
                        primaryGroup = res.iterator().next().getNameInNamespace();
                        LOG.info("Found primary group {0}", new Object[]{primaryGroup});
                    }
                }
            }
            catch (NamingException ne) {
                LOG.error((Throwable)ne, "Error retrieving primary group", new Object[0]);
                throw new ConnectorException((Throwable)ne);
            }
            TreeSet<String> newMemberships = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (String grp : ldapGroups) {
                if (currents.contains(grp)) {
                    oldMemberships.remove(grp);
                    continue;
                }
                newMemberships.add(grp);
            }
            if (StringUtil.isNotBlank(primaryGroup)) {
                newMemberships.remove(primaryGroup);
            }
            GroupHelper.Modification ldapGroupMod = new GroupHelper.Modification();
            if (!((ADConfiguration)((Object)ADConfiguration.class.cast(this.conn.getConfiguration()))).isMembershipConservativePolicy()) {
                for (String membership : oldMemberships) {
                    ldapGroupMod.remove((Object)new GroupHelper.GroupMembership(entryDN, membership));
                }
            }
            for (String membership : newMemberships) {
                ldapGroupMod.add((Object)new GroupHelper.GroupMembership(entryDN, membership));
            }
            this.groupHelper.modifyLdapGroupMemberships(ldapGroupMod);
        }
    }
}

