/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import net.tirasa.adsddl.ntsd.utils.GUID;
import net.tirasa.adsddl.ntsd.utils.Hex;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.search.ADPagedSearchStrategy;
import net.tirasa.connid.bundles.ad.search.ADVlvIndexSearchStrategy;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.search.LdapFilter;
import net.tirasa.connid.bundles.ldap.search.LdapInternalSearch;
import net.tirasa.connid.bundles.ldap.search.LdapSearchResultsHandler;
import net.tirasa.connid.bundles.ldap.search.LdapSearchStrategy;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class ADSearch {
    private final LdapConnection conn;
    private final ResultsHandler handler;
    private final ObjectClass oclass;
    private final LdapFilter filter;
    private final OperationOptions options;
    private final String[] baseDNs;
    private final ADUtilities utils;
    private static final Log LOG = Log.getLog(ADSearch.class);

    public ADSearch(LdapConnection conn, ObjectClass oclass, LdapFilter filter, ResultsHandler handler, OperationOptions options, String[] baseDNs) {
        this.conn = conn;
        this.oclass = oclass;
        this.filter = filter;
        this.handler = handler;
        this.options = options;
        this.baseDNs = baseDNs;
        this.utils = new ADUtilities((ADConnection)this.conn);
    }

    public ADSearch(LdapConnection conn, ObjectClass oclass, LdapFilter filter, ResultsHandler handler, OperationOptions options) {
        this(conn, oclass, filter, handler, options, oclass.is(ObjectClass.ACCOUNT_NAME) ? ((ADConfiguration)conn.getConfiguration()).getUserBaseContexts() : (oclass.is(ObjectClass.GROUP_NAME) ? ((ADConfiguration)conn.getConfiguration()).getGroupBaseContexts() : ((ADConfiguration)conn.getConfiguration()).getBaseContextsToSynchronize()));
    }

    public final void executeADQuery(final ResultsHandler handler) {
        String[] attrsToGetOption = this.options.getAttributesToGet();
        final Set<String> attrsToGet = this.utils.getAttributesToGet(attrsToGetOption, this.oclass);
        LdapInternalSearch search = this.getInternalSearch(attrsToGet);
        search.execute(new LdapSearchResultsHandler(){

            public boolean handle(String baseDN, SearchResult result) throws NamingException {
                return handler.handle(ADSearch.this.utils.createConnectorObject(result.getNameInNamespace(), result, (Collection<String>)attrsToGet, ADSearch.this.oclass));
            }
        });
    }

    private LdapInternalSearch getInternalSearch(Set<String> attrsToGet) {
        String membershipSearchFilter;
        String nativeFilter;
        String searchFilter;
        int searchScope;
        List<String> dns;
        LdapSearchStrategy strategy;
        String filterEntryDN;
        String string = filterEntryDN = this.filter == null ? null : this.filter.getEntryDN();
        if (filterEntryDN == null) {
            strategy = this.getSearchStrategy();
            dns = this.getBaseDNs();
            searchScope = this.getLdapSearchScope();
        } else {
            strategy = this.conn.getConfiguration().newDefaultSearchStrategy(true);
            try {
                dns = this.buildBaseContextFilter(filterEntryDN);
            }
            catch (InvalidNameException e) {
                LOG.error((Throwable)e, "Error building entry DN filter starting from '{0}'", new Object[]{filterEntryDN});
                dns = this.getBaseDNs();
            }
            searchScope = 0;
        }
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        Set<String> ldapAttrsToGet = this.utils.getLdapAttributesToGet(attrsToGet, this.oclass);
        controls.setReturningAttributes(ldapAttrsToGet.toArray(new String[ldapAttrsToGet.size()]));
        controls.setSearchScope(searchScope);
        String optionsFilter = LdapConstants.getSearchFilter((OperationOptions)this.options);
        if (LOG.isOk()) {
            LOG.ok("Options filter: {0} " + optionsFilter, new Object[0]);
        }
        String string2 = searchFilter = this.oclass.equals((Object)ObjectClass.ACCOUNT) ? this.conn.getConfiguration().getAccountSearchFilter() : ((ADConfiguration)this.conn.getConfiguration()).getGroupSearchFilter();
        if (LOG.isOk()) {
            LOG.ok("Search filter: {0} " + searchFilter, new Object[0]);
        }
        String string3 = nativeFilter = this.filter != null ? this.filter.getNativeFilter() : null;
        if (LOG.isOk()) {
            LOG.ok("Native filter: {0} " + nativeFilter, new Object[0]);
        }
        String string4 = membershipSearchFilter = this.oclass.equals((Object)ObjectClass.ACCOUNT) ? this.utils.getMembershipSearchFilter((ADConfiguration)this.conn.getConfiguration()) : null;
        if (LOG.isOk()) {
            LOG.ok("Membership filter: {0} " + membershipSearchFilter, new Object[0]);
        }
        return new LdapInternalSearch(this.conn, this.getSearchFilter(optionsFilter, nativeFilter, searchFilter, membershipSearchFilter), dns, strategy, controls);
    }

    private List<String> buildBaseContextFilter(String filterEntryDN) throws InvalidNameException {
        try {
            LdapName prefix = new LdapName(filterEntryDN);
            return this.getBaseDNs().stream().anyMatch(bdn -> {
                try {
                    return prefix.startsWith(new LdapName((String)bdn));
                }
                catch (InvalidNameException e) {
                    return false;
                }
            }) ? Collections.singletonList(prefix.toString()) : Collections.emptyList();
        }
        catch (InvalidNameException ine) {
            LOG.info((Throwable)ine, "'{0}' is not am entry DN. Let's try derive it", new Object[]{filterEntryDN});
            LdapName prefix = new LdapName(String.format("CN=%s", filterEntryDN));
            return this.getBaseDNs().stream().map(bdn -> {
                try {
                    return new LdapName((String)bdn).addAll(prefix).toString();
                }
                catch (InvalidNameException e) {
                    return bdn;
                }
            }).collect(Collectors.toList());
        }
    }

    private String getSearchFilter(String ... optionalFilters) {
        int from;
        StringBuilder builder = new StringBuilder();
        String ocFilter = this.getObjectClassFilter();
        int nonBlank = StringUtil.isBlank((String)ocFilter) ? 0 : 1;
        for (String optionalFilter : optionalFilters) {
            nonBlank += StringUtil.isBlank((String)optionalFilter) ? 0 : 1;
        }
        if (nonBlank > 1) {
            builder.append("(&");
        }
        ADSearch.appendFilter(ocFilter, builder);
        for (String optionalFilter : optionalFilters) {
            ADSearch.appendFilter(optionalFilter, builder);
        }
        if (nonBlank > 1) {
            builder.append(')');
        }
        String res = builder.toString();
        String resToLowerCase = res.toLowerCase();
        String toBeFound = "objectGUID".toLowerCase();
        StringBuilder bld = new StringBuilder();
        int to = 0;
        do {
            if ((from = resToLowerCase.indexOf(toBeFound, to)) >= 0) {
                bld.append(res.substring(to, from += 11));
                bld.append(Hex.getEscaped((byte[])GUID.getGuidAsByteArray((String)res.substring(from, to += from + 36))));
                continue;
            }
            bld.append(res.substring(to, res.length()));
        } while (from >= 0 && to < res.length());
        return bld.toString();
    }

    private LdapSearchStrategy getSearchStrategy() {
        Object result;
        if (this.options.getPageSize() != null) {
            if (this.conn.getConfiguration().isUseVlvControls() && this.conn.supportsControl("2.16.840.1.113730.3.4.9")) {
                String vlvSortAttr = this.conn.getConfiguration().getVlvSortAttribute();
                result = new ADVlvIndexSearchStrategy(vlvSortAttr, this.options.getPageSize());
            } else {
                result = this.conn.supportsControl("1.2.840.113556.1.4.319") ? new ADPagedSearchStrategy(this.options.getPageSize(), this.options.getPagedResultsCookie(), this.options.getPagedResultsOffset(), this.handler instanceof SearchResultsHandler ? (SearchResultsHandler)this.handler : null, this.options.getSortKeys()) : this.conn.getConfiguration().newDefaultSearchStrategy(true);
            }
        } else {
            result = this.conn.getConfiguration().newDefaultSearchStrategy(true);
        }
        return result;
    }

    private static void appendFilter(String filter, StringBuilder toBuilder) {
        if (!StringUtil.isBlank((String)filter)) {
            boolean enclose;
            String trimmedUserFilter = filter.trim();
            boolean bl = enclose = filter.charAt(0) != '(';
            if (enclose) {
                toBuilder.append('(');
            }
            toBuilder.append(trimmedUserFilter);
            if (enclose) {
                toBuilder.append(')');
            }
        }
    }

    private List<String> getBaseDNs() {
        QualifiedUid container = this.options.getContainer();
        List<String> result = container != null ? Collections.singletonList(LdapSearches.findEntryDN((LdapConnection)this.conn, (ObjectClass)container.getObjectClass(), (Uid)container.getUid())) : Arrays.asList(this.baseDNs);
        assert (result != null);
        return result;
    }

    private String getObjectClassFilter() {
        boolean and;
        StringBuilder builder = new StringBuilder();
        List ldapClasses = this.conn.getSchemaMapping().getLdapClasses(this.oclass);
        boolean bl = and = ldapClasses.size() > 1;
        if (and) {
            builder.append("(&");
        }
        for (String ldapClass : ldapClasses) {
            builder.append("(objectClass=");
            builder.append(ldapClass);
            builder.append(')');
        }
        if (and) {
            builder.append(')');
        }
        return builder.toString();
    }

    private int getLdapSearchScope() {
        String scope = this.options.getScope();
        if (scope == null) {
            scope = this.oclass.is(ObjectClass.ACCOUNT_NAME) ? ((ADConfiguration)this.conn.getConfiguration()).getUserSearchScope() : ((ADConfiguration)this.conn.getConfiguration()).getGroupSearchScope();
        }
        if (null == scope) {
            return 2;
        }
        switch (scope) {
            case "object": {
                return 0;
            }
            case "onelevel": {
                return 1;
            }
            case "subtree": {
                return 2;
            }
        }
        throw new IllegalArgumentException("Invalid search scope " + scope);
    }
}

