/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.modify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.GroupHelper;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.LdapModifyOperation;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.commons.StatusManagement;
import net.tirasa.connid.bundles.ldap.schema.GuardedPasswordAttribute;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaUtil;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class LdapUpdate
extends LdapModifyOperation {
    private static final Log LOG = Log.getLog(LdapUpdate.class);
    private final ObjectClass oclass;
    private final Uid uid;

    public LdapUpdate(LdapConnection conn, ObjectClass oclass, Uid uid) {
        super(conn);
        this.oclass = oclass;
        this.uid = uid;
    }

    public Uid update(Set<Attribute> attrs) {
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(this, entryDN);
        Set updateAttrs = attrs;
        Name newName = AttributeUtil.getNameFromAttributes(attrs);
        Attribute status = AttributeUtil.find((String)OperationalAttributes.ENABLE_NAME, attrs);
        String newEntryDN = null;
        if (newName != null) {
            updateAttrs = CollectionUtil.newSet(attrs);
            updateAttrs.remove(newName);
            updateAttrs.remove(AttributeUtil.find((String)LdapUtil.getDNAttributeName(newName), (Set)attrs));
            newEntryDN = this.conn.getSchemaMapping().getEntryDN(this.oclass, newName);
        }
        List<String> ldapGroups = LdapUpdate.getStringListValue(updateAttrs, "ldapGroups");
        List<String> posixGroups = LdapUpdate.getStringListValue(updateAttrs, "posixGroups");
        Pair<Attributes, GuardedPasswordAttribute> attrToModify = this.getAttributesToModify(updateAttrs);
        Attributes ldapAttrs = (Attributes)attrToModify.first;
        Set<String> newPosixRefAttrs = LdapUpdate.getAttributeValues(GroupHelper.getPosixRefAttribute(), LdapUtil.quietCreateLdapName(newEntryDN == null ? entryDN : newEntryDN), ldapAttrs);
        if (newPosixRefAttrs != null && newPosixRefAttrs.isEmpty()) {
            this.checkRemovedPosixRefAttrs(posixMember.getPosixRefAttributes(), posixMember.getPosixGroupMemberships());
        }
        if (status != null && status.getValue() != null && !status.getValue().isEmpty()) {
            StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).setStatus((boolean)((Boolean)status.getValue().get(0)), ldapAttrs);
        }
        this.modifyAttributes(entryDN, attrToModify, 2);
        String oldEntryDN = null;
        if (newName != null) {
            if (newPosixRefAttrs != null && this.conn.getConfiguration().isMaintainPosixGroupMembership() || posixGroups != null) {
                posixMember.getPosixRefAttributes();
            }
            oldEntryDN = entryDN;
            entryDN = this.conn.getSchemaMapping().rename(this.oclass, oldEntryDN, newName);
        }
        GroupHelper.Modification<GroupHelper.GroupMembership> ldapGroupMod = new GroupHelper.Modification<GroupHelper.GroupMembership>();
        if (oldEntryDN != null && this.conn.getConfiguration().isMaintainLdapGroupMembership()) {
            Set<GroupHelper.GroupMembership> members = this.groupHelper.getLdapGroupMemberships(oldEntryDN);
            ldapGroupMod.removeAll(members);
            Iterator iterator = members.iterator();
            while (iterator.hasNext()) {
                GroupHelper.GroupMembership member = (GroupHelper.GroupMembership)iterator.next();
                ldapGroupMod.add(new GroupHelper.GroupMembership(entryDN, member.getGroupDN()));
            }
        }
        if (ldapGroups != null) {
            ldapGroupMod.removeAll(this.groupHelper.getLdapGroupMemberships(entryDN));
            ldapGroupMod.clearAdded();
            for (String ldapGroup : ldapGroups) {
                ldapGroupMod.add(new GroupHelper.GroupMembership(entryDN, ldapGroup));
            }
        }
        this.groupHelper.modifyLdapGroupMemberships(ldapGroupMod);
        GroupHelper.Modification<GroupHelper.GroupMembership> posixGroupMod = new GroupHelper.Modification<GroupHelper.GroupMembership>();
        if (newPosixRefAttrs != null && this.conn.getConfiguration().isMaintainPosixGroupMembership()) {
            HashSet<String> removedPosixRefAttrs = new HashSet<String>(posixMember.getPosixRefAttributes());
            removedPosixRefAttrs.removeAll(newPosixRefAttrs);
            Set<GroupHelper.GroupMembership> members = posixMember.getPosixGroupMembershipsByAttrs(removedPosixRefAttrs);
            posixGroupMod.removeAll(members);
            if (!members.isEmpty()) {
                String firstPosixRefAttr = this.getFirstPosixRefAttr(entryDN, newPosixRefAttrs);
                for (GroupHelper.GroupMembership member : members) {
                    posixGroupMod.add(new GroupHelper.GroupMembership(firstPosixRefAttr, member.getGroupDN()));
                }
            }
        }
        if (posixGroups != null) {
            posixGroupMod.removeAll(posixMember.getPosixGroupMemberships());
            posixGroupMod.clearAdded();
            if (!posixGroups.isEmpty()) {
                String firstPosixRefAttr = this.getFirstPosixRefAttr(entryDN, newPosixRefAttrs);
                for (String posixGroup : posixGroups) {
                    posixGroupMod.add(new GroupHelper.GroupMembership(firstPosixRefAttr, posixGroup));
                }
            }
        }
        this.groupHelper.modifyPosixGroupMemberships(posixGroupMod);
        return this.conn.getSchemaMapping().createUid(this.oclass, entryDN);
    }

    public Set<AttributeDelta> updateDelta(Set<AttributeDelta> modifications) {
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(this, entryDN);
        Optional.ofNullable(AttributeDeltaUtil.find((String)OperationalAttributes.ENABLE_NAME, modifications)).filter(status -> !CollectionUtil.isEmpty((Collection)status.getValuesToReplace())).ifPresent(status -> {
            StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).setStatus((boolean)((Boolean)status.getValuesToReplace().get(0)), modifications);
            modifications.remove(status);
        });
        GuardedPasswordAttribute guardedPasswordAttribute = null;
        ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>();
        for (AttributeDelta attrDelta : modifications) {
            if (attrDelta.is(Uid.NAME) || attrDelta.is(Name.NAME)) {
                throw new IllegalArgumentException("Do not perform rename via updateDelta, use standard update");
            }
            if (LdapConstants.isLdapGroups(attrDelta.getName()) || LdapConstants.isPosixGroups(attrDelta.getName())) continue;
            if (attrDelta.is(OperationalAttributes.PASSWORD_NAME)) {
                guardedPasswordAttribute = this.conn.getSchemaMapping().encodePassword(attrDelta);
                continue;
            }
            modItems.addAll(this.conn.getSchemaMapping().encodeAttribute(this.oclass, attrDelta));
        }
        if (guardedPasswordAttribute != null) {
            guardedPasswordAttribute.access(passwordAttr -> {
                this.hashPassword(passwordAttr, entryDN);
                modItems.add(new ModificationItem(2, passwordAttr));
                this.modifyAttributes(entryDN, modItems);
            });
        } else {
            this.modifyAttributes(entryDN, modItems);
        }
        Optional.ofNullable(AttributeDeltaUtil.find((String)"ldapGroups", modifications)).ifPresent(ldapGroups -> {
            GroupHelper.Modification<GroupHelper.GroupMembership> ldapGroupMod = new GroupHelper.Modification<GroupHelper.GroupMembership>();
            if (CollectionUtil.isEmpty((Collection)ldapGroups.getValuesToReplace())) {
                if (!CollectionUtil.isEmpty((Collection)ldapGroups.getValuesToAdd())) {
                    for (String ldapGroup : LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)ldapGroups.getValuesToAdd()), String.class)) {
                        ldapGroupMod.add(new GroupHelper.GroupMembership(entryDN, ldapGroup));
                    }
                }
                if (!CollectionUtil.isEmpty((Collection)ldapGroups.getValuesToRemove())) {
                    for (String ldapGroup : LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)ldapGroups.getValuesToRemove()), String.class)) {
                        ldapGroupMod.remove(new GroupHelper.GroupMembership(entryDN, ldapGroup));
                    }
                }
            } else {
                ldapGroupMod.removeAll(this.groupHelper.getLdapGroupMemberships(entryDN));
                ldapGroupMod.clearAdded();
                for (String ldapGroup : LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)ldapGroups.getValuesToReplace()), String.class)) {
                    ldapGroupMod.add(new GroupHelper.GroupMembership(entryDN, ldapGroup));
                }
            }
            if (!ldapGroupMod.isEmpty()) {
                this.groupHelper.modifyLdapGroupMemberships(ldapGroupMod);
            }
        });
        Optional.ofNullable(AttributeDeltaUtil.find((String)"posixGroups", modifications)).ifPresent(posixGroups -> {
            Set<String> posixRefAttrs = posixMember.getPosixRefAttributes();
            String firstPosixRefAttr = this.getFirstPosixRefAttr(entryDN, posixRefAttrs);
            GroupHelper.Modification<GroupHelper.GroupMembership> posixGroupMod = new GroupHelper.Modification<GroupHelper.GroupMembership>();
            if (CollectionUtil.isEmpty((Collection)posixGroups.getValuesToReplace())) {
                if (!CollectionUtil.isEmpty((Collection)posixGroups.getValuesToAdd())) {
                    for (String posixGroup : LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)posixGroups.getValuesToAdd()), String.class)) {
                        posixGroupMod.add(new GroupHelper.GroupMembership(firstPosixRefAttr, posixGroup));
                    }
                }
                if (!CollectionUtil.isEmpty((Collection)posixGroups.getValuesToRemove())) {
                    for (String posixGroup : LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)posixGroups.getValuesToRemove()), String.class)) {
                        posixGroupMod.remove(new GroupHelper.GroupMembership(firstPosixRefAttr, posixGroup));
                    }
                }
            } else {
                posixGroupMod.removeAll(posixMember.getPosixGroupMemberships());
                posixGroupMod.clearAdded();
                for (String posixGroup : LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)posixGroups.getValuesToReplace()), String.class)) {
                    posixGroupMod.add(new GroupHelper.GroupMembership(firstPosixRefAttr, posixGroup));
                }
            }
            if (!posixGroupMod.isEmpty()) {
                this.groupHelper.modifyPosixGroupMemberships(posixGroupMod);
            }
        });
        return modifications;
    }

    public Uid addAttributeValues(Set<Attribute> attrs) {
        List<String> posixGroups;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(this, entryDN);
        Pair<Attributes, GuardedPasswordAttribute> attrsToModify = this.getAttributesToModify(attrs);
        this.modifyAttributes(entryDN, attrsToModify, 1);
        List<String> ldapGroups = LdapUpdate.getStringListValue(attrs, "ldapGroups");
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.addLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (!CollectionUtil.isEmpty(posixGroups = LdapUpdate.getStringListValue(attrs, "posixGroups"))) {
            Set<String> posixRefAttrs = posixMember.getPosixRefAttributes();
            String posixRefAttr = this.getFirstPosixRefAttr(entryDN, posixRefAttrs);
            this.groupHelper.addPosixGroupMemberships(posixRefAttr, posixGroups);
        }
        return this.uid;
    }

    public Uid removeAttributeValues(Set<Attribute> attrs) {
        List<String> posixGroups;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(this, entryDN);
        Pair<Attributes, GuardedPasswordAttribute> attrsToModify = this.getAttributesToModify(attrs);
        Attributes ldapAttrs = (Attributes)attrsToModify.first;
        Set<String> removedPosixRefAttrs = LdapUpdate.getAttributeValues(GroupHelper.getPosixRefAttribute(), null, ldapAttrs);
        if (!CollectionUtil.isEmpty(removedPosixRefAttrs)) {
            this.checkRemovedPosixRefAttrs(removedPosixRefAttrs, posixMember.getPosixGroupMemberships());
        }
        this.modifyAttributes(entryDN, attrsToModify, 3);
        List<String> ldapGroups = LdapUpdate.getStringListValue(attrs, "ldapGroups");
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.removeLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (!CollectionUtil.isEmpty(posixGroups = LdapUpdate.getStringListValue(attrs, "posixGroups"))) {
            Set<GroupHelper.GroupMembership> members = posixMember.getPosixGroupMembershipsByGroups(posixGroups);
            this.groupHelper.removePosixGroupMemberships(members);
        }
        return this.uid;
    }

    private void checkRemovedPosixRefAttrs(Set<String> removedPosixRefAttrs, Set<GroupHelper.GroupMembership> memberships) {
        for (GroupHelper.GroupMembership membership : memberships) {
            if (!removedPosixRefAttrs.contains(membership.getMemberRef())) continue;
            throw new ConnectorException(this.conn.format("cannotRemoveBecausePosixMember", GroupHelper.getPosixRefAttribute(), new Object[0]));
        }
    }

    private Pair<Attributes, GuardedPasswordAttribute> getAttributesToModify(Set<Attribute> attrs) {
        BasicAttributes ldapAttrs = new BasicAttributes();
        GuardedPasswordAttribute pwdAttr = null;
        for (Attribute attr : attrs) {
            javax.naming.directory.Attribute ldapAttr = null;
            if (attr.is(Uid.NAME)) {
                throw new IllegalArgumentException("Unable to modify an object's uid");
            }
            if (attr.is(Name.NAME)) {
                throw new IllegalArgumentException("Unable to modify an object's name");
            }
            if (!LdapConstants.isLdapGroups(attr.getName()) && !LdapConstants.isPosixGroups(attr.getName())) {
                if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                    pwdAttr = this.conn.getSchemaMapping().encodePassword(attr);
                } else {
                    ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, attr);
                }
            }
            if (ldapAttr == null) continue;
            javax.naming.directory.Attribute existingAttr = ldapAttrs.get(ldapAttr.getID());
            if (existingAttr != null) {
                try {
                    NamingEnumeration<?> all = ldapAttr.getAll();
                    while (all.hasMoreElements()) {
                        existingAttr.add(all.nextElement());
                    }
                    continue;
                }
                catch (NamingException e) {
                    throw new ConnectorException((Throwable)e);
                }
            }
            ldapAttrs.put(ldapAttr);
        }
        return Pair.of((Object)ldapAttrs, pwdAttr);
    }

    private void modifyAttributes(String entryDN, Pair<Attributes, GuardedPasswordAttribute> attrs, int ldapModifyOp) {
        ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>(((Attributes)attrs.first).size());
        NamingEnumeration<? extends javax.naming.directory.Attribute> attrEnum = ((Attributes)attrs.first).getAll();
        while (attrEnum.hasMoreElements()) {
            modItems.add(new ModificationItem(ldapModifyOp, (javax.naming.directory.Attribute)attrEnum.nextElement()));
        }
        if (attrs.second != null) {
            ((GuardedPasswordAttribute)attrs.second).access(passwordAttr -> {
                this.hashPassword(passwordAttr, entryDN);
                modItems.add(new ModificationItem(ldapModifyOp, passwordAttr));
                this.modifyAttributes(entryDN, modItems);
            });
        } else {
            this.modifyAttributes(entryDN, modItems);
        }
    }

    private void modifyAttributes(String entryDN, List<ModificationItem> modItems) {
        LOG.ok("About to apply to {0} the following modifications: {1}", new Object[]{entryDN, modItems});
        try {
            this.conn.getInitialContext().modifyAttributes(entryDN, modItems.toArray(new ModificationItem[0]));
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private static List<String> getStringListValue(Set<Attribute> attrs, String attrName) {
        return Optional.ofNullable(AttributeUtil.find((String)attrName, attrs)).map(attr -> LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)attr.getValue()), String.class)).orElse(null);
    }
}

