/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.tirasa.connid.bundles.scim.common.dto.SCIMSchema;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.StatefulConfiguration;

public class SCIMConnectorConfiguration
extends AbstractConfiguration
implements StatefulConfiguration {
    private static final Log LOG = Log.getLog(SCIMConnectorConfiguration.class);
    private String username;
    private GuardedString password;
    private String bearerToken;
    private String baseAddress;
    private String customAttributesJSON;
    private String updateUserMethod = "PUT";
    private String updateGroupMethod = "PUT";
    private Boolean explicitGroupAddOnCreate = false;
    private String accept = "application/json";
    private String contentType = "application/json";
    private String clientId;
    private String clientSecret;
    private String accessTokenNodeId = "access_token";
    private String accessTokenBaseAddress;
    private String accessTokenContentType = "application/x-www-form-urlencoded";
    private String addressesType;
    private String genericComplexType;
    private Boolean manageComplexEntitlements = false;

    @ConfigurationProperty(order=1, displayMessageKey="baseAddress.display", helpMessageKey="baseAddress.help", required=true)
    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    @ConfigurationProperty(displayMessageKey="accept.display", helpMessageKey="accept.help", order=2, required=true)
    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    @ConfigurationProperty(displayMessageKey="contentType.display", helpMessageKey="contentType.help", order=3, required=true)
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @ConfigurationProperty(displayMessageKey="username.display", helpMessageKey="username.help", order=4)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @ConfigurationProperty(displayMessageKey="password.display", helpMessageKey="password.help", order=5, confidential=true)
    public GuardedString getPassword() {
        return this.password;
    }

    public void setPassword(GuardedString password) {
        this.password = password;
    }

    @ConfigurationProperty(displayMessageKey="bearerToken.display", helpMessageKey="bearerToken.help", order=6, confidential=true)
    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @ConfigurationProperty(displayMessageKey="clientId.display", helpMessageKey="clientId.help", order=7)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ConfigurationProperty(displayMessageKey="clientSecret.display", helpMessageKey="clientSecret.help", order=8, confidential=true)
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @ConfigurationProperty(displayMessageKey="customAttributesJSON.display", helpMessageKey="customAttributesJSON.help", order=9)
    public String getCustomAttributesJSON() {
        return this.customAttributesJSON;
    }

    public void setCustomAttributesJSON(String customAttributesJSON) {
        this.customAttributesJSON = customAttributesJSON;
    }

    @ConfigurationProperty(displayMessageKey="updateUserMethod.display", helpMessageKey="updateUserMethod.help", order=10)
    public String getUpdateUserMethod() {
        return this.updateUserMethod;
    }

    public void setUpdateUserMethod(String updateUserMethod) {
        this.updateUserMethod = updateUserMethod;
    }

    @ConfigurationProperty(displayMessageKey="updateGroupMethod.display", helpMessageKey="updateGroupMethod.help", order=10)
    public String getUpdateGroupMethod() {
        return this.updateGroupMethod;
    }

    @ConfigurationProperty(displayMessageKey="updateGroupMethod.display", helpMessageKey="updateGroupMethod.help", order=10)
    public void setUpdateGroupMethod(String updateGroupMethod) {
        this.updateGroupMethod = updateGroupMethod;
    }

    @ConfigurationProperty(displayMessageKey="explicitGroupAddOnCreate.display", helpMessageKey="explicitGroupAddOnCreate.help", order=11)
    public Boolean getExplicitGroupAddOnCreate() {
        return this.explicitGroupAddOnCreate;
    }

    public void setExplicitGroupAddOnCreate(Boolean explicitGroupAddOnCreate) {
        this.explicitGroupAddOnCreate = explicitGroupAddOnCreate;
    }

    @ConfigurationProperty(displayMessageKey="accessTokenNodeId.display", helpMessageKey="accessTokenNodeId.help", order=12)
    public String getAccessTokenNodeId() {
        return this.accessTokenNodeId;
    }

    public void setAccessTokenNodeId(String accessTokenNodeId) {
        this.accessTokenNodeId = accessTokenNodeId;
    }

    @ConfigurationProperty(displayMessageKey="accessTokenBaseAddress.display", helpMessageKey="accessTokenBaseAddress.help", order=13)
    public String getAccessTokenBaseAddress() {
        return this.accessTokenBaseAddress;
    }

    public void setAccessTokenBaseAddress(String accessTokenBaseAddress) {
        this.accessTokenBaseAddress = accessTokenBaseAddress;
    }

    @ConfigurationProperty(displayMessageKey="accessTokenContentType.display", helpMessageKey="accessTokenContentType.help", order=14)
    public String getAccessTokenContentType() {
        return this.accessTokenContentType;
    }

    public void setAccessTokenContentType(String accessTokenContentType) {
        this.accessTokenContentType = accessTokenContentType;
    }

    @ConfigurationProperty(displayMessageKey="addressesType.display", helpMessageKey="addressesType.help", order=15)
    public String getAddressesType() {
        return this.addressesType;
    }

    public void setAddressesType(String addressesType) {
        this.addressesType = addressesType;
    }

    @ConfigurationProperty(displayMessageKey="genericComplexType.display", helpMessageKey="genericComplexType.help", order=16)
    public String getGenericComplexType() {
        return this.genericComplexType;
    }

    public void setManageComplexEntitlements(Boolean manageComplexEntitlements) {
        this.manageComplexEntitlements = manageComplexEntitlements;
    }

    @ConfigurationProperty(displayMessageKey="manageComplexEntitlements.display", helpMessageKey="manageComplexEntitlements.help", order=17)
    public Boolean getManageComplexEntitlements() {
        return this.manageComplexEntitlements;
    }

    public void setGenericComplexType(String genericComplexType) {
        this.genericComplexType = genericComplexType;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.baseAddress)) {
            this.failValidation("Base address cannot be null or empty.", new Object[0]);
        }
        try {
            new URL(this.baseAddress);
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e, "While validating baseAddress", new Object[0]);
            this.failValidation("Base address must be a valid URL.", new Object[0]);
        }
        if (StringUtil.isBlank((String)this.username) && StringUtil.isBlank((String)this.clientId) && StringUtil.isBlank((String)this.clientSecret) && StringUtil.isBlank((String)this.accessTokenNodeId) && StringUtil.isBlank((String)this.accessTokenBaseAddress)) {
            this.failValidation("Username cannot be null or empty since clientId, clientSecret, accessTokenNodeId and accessTokenBaseAddress are blank", new Object[0]);
        }
        if (this.password != null && StringUtil.isBlank((String)SecurityUtil.decrypt((GuardedString)this.password)) && StringUtil.isBlank((String)this.clientId) && StringUtil.isBlank((String)this.clientSecret) && StringUtil.isBlank((String)this.accessTokenNodeId) && StringUtil.isBlank((String)this.accessTokenBaseAddress)) {
            this.failValidation("Password cannot be null or empty since clientId, clientSecret, accessTokenNodeId and accessTokenBaseAddress are blank", new Object[0]);
        }
        if (StringUtil.isNotBlank((String)this.customAttributesJSON)) {
            try {
                SCIMUtils.MAPPER.readValue(this.customAttributesJSON, SCIMSchema.class);
            }
            catch (IOException e) {
                LOG.error((Throwable)e, "While validating customAttributesJSON", new Object[0]);
                this.failValidation("'customAttributesJSON' parameter must be a valid Resource Schema Representation JSON.", new Object[0]);
            }
        }
        if (!"PATCH".equalsIgnoreCase(this.updateUserMethod) && !"PUT".equalsIgnoreCase(this.updateUserMethod)) {
            this.failValidation("Update method is not valid; must be 'PUT' or 'PATCH'.", new Object[0]);
        }
    }

    public void release() {
    }

    private void failValidation(String key, Object ... args) {
        String message = this.getConnectorMessages().format(key, null, args);
        throw new ConfigurationException(message);
    }
}

