/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v11;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.AbstractSCIMConnector;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.SCIMProvider;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseResource;
import net.tirasa.connid.bundles.scim.common.dto.SCIMSchema;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11BasePatch;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Group;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11GroupPatch;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Meta;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11User;
import net.tirasa.connid.bundles.scim.v11.dto.Scimv11GroupPatchOperation;
import net.tirasa.connid.bundles.scim.v11.service.SCIMv11Client;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.spi.ConnectorClass;

@ConnectorClass(displayNameKey="SCIMv11Connector.connector.display", configurationClass=SCIMConnectorConfiguration.class)
public class SCIMv11Connector
extends AbstractSCIMConnector<SCIMv11User, SCIMv11Group, SCIMBaseResource<SCIMv11Meta>, SCIMv11BasePatch, SCIMv11Client> {
    private Schema schema;

    @Override
    protected SCIMv11Client buildSCIMClient(SCIMConnectorConfiguration configuration) {
        return new SCIMv11Client(configuration);
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = SCIMAttributeUtils.buildSchema(this.configuration.getCustomAttributesJSON(), this.configuration.getManageComplexEntitlements(), SCIMv11Attribute.class);
        }
        return this.schema;
    }

    @Override
    public SCIMv11Client getClient() {
        return (SCIMv11Client)this.client;
    }

    @Override
    protected <T extends SCIMBaseAttribute<T>> SCIMv11User buildNewUserEntity(Optional<SCIMSchema<T>> customSchema) {
        SCIMv11User newUser = new SCIMv11User();
        customSchema.ifPresent(cs -> newUser.getSchemas().add(cs.getId()));
        return newUser;
    }

    @Override
    protected SCIMv11Group buildNewGroupEntity() {
        return new SCIMv11Group();
    }

    @Override
    protected void fillGroupPatches(SCIMv11User user, Map<String, SCIMv11BasePatch> groupPatches, List<String> groupsToAdd, List<String> groupsToRemove) {
        groupsToAdd.forEach(grp -> {
            SCIMv11BasePatch cfr_ignored_0 = (SCIMv11BasePatch)groupPatches.put((String)grp, (SCIMv11BasePatch)this.buildMembersGroupPatch((List)Collections.singletonList(user), "add"));
        });
        groupsToRemove.forEach(grp -> {
            SCIMv11BasePatch cfr_ignored_0 = (SCIMv11BasePatch)groupPatches.put((String)grp, (SCIMv11BasePatch)this.buildMembersGroupPatch((List)Collections.singletonList(user), "remove"));
        });
    }

    @Override
    protected SCIMv11BasePatch buildMembersGroupPatch(List<SCIMv11User> users, String op) {
        return new SCIMv11GroupPatch.Builder().members(users.stream().map(user -> new Scimv11GroupPatchOperation.Builder().operation("add").display(this.provider.equals((Object)SCIMProvider.WSO2) ? user.getUserName() : user.getDisplayName()).value(user.getId()).build()).collect(Collectors.toList())).build();
    }

    @Override
    protected SCIMv11BasePatch buildPatchFromGroup(SCIMv11Group group) {
        throw new IllegalArgumentException("Not implemented, yet");
    }

    @Override
    protected void manageEntitlements(SCIMv11User user, List<String> values) {
    }
}

