/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scimv11;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.scimv11.SCIMv11ConnectorConfiguration;
import net.tirasa.connid.bundles.scimv11.dto.PagedResults;
import net.tirasa.connid.bundles.scimv11.dto.User;
import net.tirasa.connid.bundles.scimv11.service.SCIMv11Client;
import net.tirasa.connid.bundles.scimv11.utils.SCIMv11Attributes;
import net.tirasa.connid.bundles.scimv11.utils.SCIMv11Utils;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="SCIMv11Connector.connector.display", configurationClass=SCIMv11ConnectorConfiguration.class)
public class SCIMv11Connector
implements Connector,
CreateOp,
DeleteOp,
SchemaOp,
SearchOp<Filter>,
TestOp,
UpdateOp {
    private static final Log LOG = Log.getLog(SCIMv11Connector.class);
    private SCIMv11ConnectorConfiguration configuration;
    private Schema schema;
    private SCIMv11Client client;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        LOG.ok("Init", new Object[0]);
        this.configuration = (SCIMv11ConnectorConfiguration)configuration;
        this.configuration.validate();
        this.client = new SCIMv11Client(this.configuration);
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public void dispose() {
        LOG.ok("Configuration cleanup", new Object[0]);
        this.configuration = null;
    }

    public void test() {
        LOG.ok("Connector TEST", new Object[0]);
        if (this.configuration != null) {
            if (this.client != null && this.client.testService()) {
                LOG.ok("Test was successfull", new Object[0]);
            } else {
                SCIMv11Utils.handleGeneralError("Test error. Problems with client service");
            }
        } else {
            LOG.error("Test error. No instance of the configuration class", new Object[0]);
        }
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = SCIMv11Attributes.buildSchema(this.configuration.getCustomAttributesJSON());
        }
        return this.schema;
    }

    public FilterTranslator<Filter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        return new FilterTranslator<Filter>(){

            public List<Filter> translate(Filter filter) {
                return Collections.singletonList(filter);
            }
        };
    }

    public void executeQuery(ObjectClass objectClass, Filter query, ResultsHandler handler, OperationOptions options) {
        Attribute filterAttr;
        LOG.ok("Connector READ", new Object[0]);
        Attribute key = null;
        if (query instanceof EqualsFilter && ((filterAttr = ((EqualsFilter)query).getAttribute()) instanceof Uid || ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass))) {
            key = filterAttr;
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            if (key == null) {
                List<User> users = null;
                int remainingResults = -1;
                int pagesSize = options.getPageSize() == null ? -1 : options.getPageSize();
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        PagedResults<User> pagedResult;
                        cookie = StringUtil.isNotBlank((String)cookie) ? ((users = (pagedResult = this.client.getAllUsers(Integer.valueOf(cookie), pagesSize, attributesToGet)).getResources()).size() >= pagesSize ? String.valueOf(pagedResult.getStartIndex() + users.size()) : null) : ((users = (pagedResult = this.client.getAllUsers(1, pagesSize, attributesToGet)).getResources()).size() >= pagesSize ? String.valueOf(pagedResult.getStartIndex() + users.size()) : null);
                    } else {
                        users = this.client.getAllUsers(attributesToGet);
                    }
                }
                catch (Exception e) {
                    SCIMv11Utils.wrapGeneralError("While getting Users!", e);
                }
                for (User user : users) {
                    handler.handle(this.fromUser(user, attributesToGet));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else {
                User result = null;
                if (Uid.NAME.equals(key.getName()) || "id".equals(key.getName())) {
                    result = null;
                    try {
                        result = this.client.getUser(AttributeUtil.getAsStringValue((Attribute)key));
                    }
                    catch (Exception e) {
                        SCIMv11Utils.wrapGeneralError("While getting User : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                    }
                } else if (Name.NAME.equals(key.getName())) {
                    try {
                        List<User> users = this.client.getAllUsers("username eq \"" + AttributeUtil.getAsStringValue((Attribute)key) + "\"", attributesToGet);
                        if (!users.isEmpty()) {
                            result = users.get(0);
                        }
                    }
                    catch (Exception e) {
                        SCIMv11Utils.wrapGeneralError("While getting User : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                    }
                }
                if (result != null) {
                    handler.handle(this.fromUser(result, attributesToGet));
                }
            }
        } else {
            LOG.warn("Search of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        LOG.ok("Connector CREATE", new Object[0]);
        if (createAttributes == null || createAttributes.isEmpty()) {
            SCIMv11Utils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(createAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            User user = new User();
            String username = accessor.findString("userName");
            if (username == null) {
                username = accessor.findString(Name.NAME);
            }
            String externalId = accessor.findString("externalId");
            GuardedString password = accessor.findGuardedString(OperationalAttributes.PASSWORD_NAME);
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            try {
                user.setUserName(username);
                user.setExternalId(externalId != null ? externalId : username);
                if (password == null) {
                    LOG.warn("Missing password attribute", new Object[0]);
                } else {
                    user.setPassword(SecurityUtil.decrypt((GuardedString)password));
                }
                if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                    LOG.warn("{0} attribute value not correct or not found, won't handle User status", new Object[]{OperationalAttributes.ENABLE_NAME});
                } else {
                    user.setActive(Boolean.parseBoolean(status.getValue().get(0).toString()));
                }
                user.fromAttributes(createAttributes);
                if (StringUtil.isNotBlank((String)this.configuration.getCustomAttributesJSON())) {
                    user.fillSCIMCustomAttributes(createAttributes, this.configuration.getCustomAttributesJSON());
                }
                this.client.createUser(user);
            }
            catch (Exception e) {
                SCIMv11Utils.wrapGeneralError("Could not create User : " + username, e);
            }
            return new Uid(user.getId());
        }
        LOG.warn("Create of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        LOG.ok("Connector DELETE", new Object[0]);
        if (StringUtil.isBlank((String)uid.getUidValue())) {
            LOG.error("Uid not provided or empty ", new Object[0]);
            throw new InvalidAttributeValueException("Uid value not provided or empty");
        }
        if (objectClass == null) {
            LOG.error("Object value not provided {0} ", new Object[]{objectClass});
            throw new InvalidAttributeValueException("Object value not provided");
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            try {
                this.client.deleteUser(uid.getUidValue());
            }
            catch (Exception e) {
                SCIMv11Utils.wrapGeneralError("Could not delete User " + uid.getUidValue(), e);
            }
        } else {
            LOG.warn("Delete of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        LOG.ok("Connector UPDATE", new Object[0]);
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            SCIMv11Utils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            Uid returnUid = uid;
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            String username = accessor.findString("userName");
            if (username == null) {
                username = accessor.findString(Name.NAME);
            }
            User user = new User();
            user.setId(uid.getUidValue());
            user.setUserName(username);
            if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                LOG.warn("{0} attribute value not correct, can't handle User  status update", new Object[]{OperationalAttributes.ENABLE_NAME});
            } else {
                user.setActive(Boolean.parseBoolean(status.getValue().get(0).toString()));
            }
            if (StringUtil.isNotBlank((String)this.configuration.getCustomAttributesJSON())) {
                user.fillSCIMCustomAttributes(replaceAttributes, this.configuration.getCustomAttributesJSON());
            }
            try {
                GuardedString password;
                user.fromAttributes(replaceAttributes);
                GuardedString guardedString = password = accessor.getPassword() != null ? accessor.getPassword() : accessor.findGuardedString(OperationalAttributes.PASSWORD_NAME);
                if (password == null) {
                    LOG.info("No password to update", new Object[0]);
                } else {
                    String decryptedPassword = SecurityUtil.decrypt((GuardedString)password);
                    user.setPassword(decryptedPassword);
                }
                this.client.updateUser(user);
                returnUid = new Uid(user.getId());
            }
            catch (Exception e) {
                SCIMv11Utils.wrapGeneralError("Could not update User " + uid.getUidValue() + " from attributes ", e);
            }
            return returnUid;
        }
        LOG.warn("Update of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public SCIMv11Client getClient() {
        return this.client;
    }

    private ConnectorObject fromUser(User user, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.ACCOUNT);
        builder.setUid(user.getId());
        builder.setName(user.getUserName());
        try {
            Set<Attribute> userAttributes = user.toAttributes();
            block2: for (Attribute toAttribute : userAttributes) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block2;
                }
            }
            if (StringUtil.isNotBlank((String)this.configuration.getCustomAttributesJSON())) {
                for (String customAttributeKey : user.getReturnedCustomAttributes().keySet()) {
                    builder.addAttribute(customAttributeKey, (Collection)user.getReturnedCustomAttributes().get(customAttributeKey));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        return builder.build();
    }
}

