/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scimv11.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.tirasa.connid.bundles.scimv11.SCIMv11Connector;
import net.tirasa.connid.bundles.scimv11.dto.SCIMAttribute;
import net.tirasa.connid.bundles.scimv11.dto.SCIMSchema;
import net.tirasa.connid.bundles.scimv11.service.SCIMv11Service;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributeInfos;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;

public final class SCIMv11Attributes {
    public static final String USER_ATTRIBUTE_ID = "id";
    public static final String USER_ATTRIBUTE_USERNAME = "userName";
    public static final String USER_ATTRIBUTE_PASSWORD = "password";
    public static final String USER_ATTRIBUTE_ACTIVE = "active";
    public static final String USER_ATTRIBUTE_EXTERNAL_ID = "externalId";
    public static final String SCIM_USER_NAME = "name";
    public static final String SCIM_USER_META = "meta";
    public static final String SCIM_USER_ADDRESSES = "addresses";
    public static final String SCIM_USER_PHONE_NUMBERS = "phoneNumbers";
    public static final String SCIM_USER_IMS = "ims";
    public static final String SCIM_USER_EMAILS = "emails";
    public static final String SCIM_USER_ROLES = "roles";
    public static final String SCIM_USER_ENTITLEMENTS = "entitlements";
    public static final String SCIM_USER_X509CERTIFICATES = "x509Certificates";
    public static final String SCIM_USER_GROUPS = "groups";
    public static final String SCIM_USER_PHOTOS = "photos";
    public static final String SCIM_USER_SCHEMAS = "schemas";
    public static final String SCIM_SCHEMA_TYPE_COMPLEX = "complex";
    public static final String SCIM_SCHEMA_EXTENSION = "extension";

    public static Schema buildSchema(String customAttributes) {
        SCIMSchema scimSchema;
        SchemaBuilder builder = new SchemaBuilder(SCIMv11Connector.class);
        ObjectClassInfoBuilder userBuilder = new ObjectClassInfoBuilder().setType(ObjectClass.ACCOUNT_NAME);
        userBuilder.addAttributeInfo(Name.INFO);
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)USER_ATTRIBUTE_ID).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)USER_ATTRIBUTE_EXTERNAL_ID).setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)USER_ATTRIBUTE_USERNAME).setRequired(true).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.formatted").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.familyName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.givenName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.middleName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.honorificPrefix").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.honorificSuffix").build());
        userBuilder.addAttributeInfo(OperationalAttributeInfos.ENABLE);
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)USER_ATTRIBUTE_ACTIVE).setType(Boolean.class).build());
        userBuilder.addAttributeInfo(OperationalAttributeInfos.PASSWORD);
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"displayName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"nickName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"profileUrl").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"title").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"userType").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"locale").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"preferredLanguage").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"timezone").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.work.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.work.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.work.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.home.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.home.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.home.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.other.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.other.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.other.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.work.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.work.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.work.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.other.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.other.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.other.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.pager.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.pager.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.pager.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.fax.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.fax.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.fax.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.mobile.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.mobile.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.mobile.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.aim.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.aim.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.aim.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.xmpp.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.xmpp.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.xmpp.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.skype.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.skype.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.skype.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.qq.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.qq.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.qq.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.yahoo.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.yahoo.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.yahoo.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.msn.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.msn.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.msn.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.icq.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.icq.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.icq.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.gtalk.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.gtalk.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.gtalk.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.photo.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.photo.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.photo.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.thumbnail.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.thumbnail.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.thumbnail.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.streetAddress").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.locality").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.region").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.postalCode").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.country").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.formatted").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.streetAddress").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.locality").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.region").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.postalCode").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.country").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.formatted").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.streetAddress").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.locality").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.region").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.postalCode").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.country").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.formatted").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"groups.default.value").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"roles.default.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"entitlements.default.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"x509Certificates.default.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)SCIM_USER_SCHEMAS).setMultiValued(true).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.created").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.lastModified").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.location").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.version").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.attributes").setMultiValued(true).build());
        if (StringUtil.isNotBlank((String)customAttributes) && (scimSchema = SCIMv11Service.extractSCIMSchemas(customAttributes)) != null && !scimSchema.getAttributes().isEmpty()) {
            for (SCIMAttribute attribute : scimSchema.getAttributes()) {
                AttributeInfoBuilder attributeInfoBuilder = AttributeInfoBuilder.define((String)attribute.getSchema().concat(".").concat(attribute.getName()));
                attributeInfoBuilder.setMultiValued(attribute.getMultiValued().booleanValue()).setRequired(attribute.getRequired().booleanValue()).setUpdateable(attribute.getReadOnly() == false);
                switch (attribute.getType()) {
                    case "string": {
                        attributeInfoBuilder.setType(String.class);
                        break;
                    }
                    case "boolean": {
                        attributeInfoBuilder.setType(Boolean.class);
                    }
                }
                userBuilder.addAttributeInfo(attributeInfoBuilder.build());
            }
        }
        ObjectClassInfo user = userBuilder.build();
        builder.defineObjectClass(user);
        return builder.build();
    }

    public static AttributeBuilder buildAttributeFromClassField(Field field, Object that) throws IllegalArgumentException, IllegalAccessException {
        return SCIMv11Attributes.doBuildAttributeFromClassField(field.get(that), field.getName(), field.getType());
    }

    public static AttributeBuilder doBuildAttributeFromClassField(Object value, String name, Class<?> clazz) {
        AttributeBuilder attributeBuilder = new AttributeBuilder();
        if (value != null) {
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                attributeBuilder.addValue(new Object[]{Boolean.class.cast(value)});
            } else if (value instanceof List) {
                ArrayList list = new ArrayList((List)value);
                if (list.size() > 1) {
                    for (Object elem : list) {
                        SCIMv11Attributes.doBuildAttributeFromClassField(elem, name, clazz);
                    }
                } else if (!list.isEmpty()) {
                    attributeBuilder.addValue(new Object[]{list.get(0).toString()});
                }
            } else {
                attributeBuilder.addValue(new Object[]{value.toString()});
            }
        }
        if (name != null) {
            attributeBuilder.setName(name);
        }
        return attributeBuilder;
    }

    public static String defaultAttributesToGet() {
        return USER_ATTRIBUTE_USERNAME.concat(",").concat(USER_ATTRIBUTE_ID).concat(",").concat(SCIM_USER_NAME);
    }
}

