/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta.schema;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.ExtensibleResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.tirasa.connid.bundles.okta.OktaConnector;
import net.tirasa.connid.bundles.okta.utils.OktaAttribute;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;

class OktaSchemaBuilder {
    private static final Log LOG = Log.getLog(OktaSchemaBuilder.class);
    public static final String SCHEMA_DEFINITIONS = "definitions";
    public static final String SCHEMA_BASE = "base";
    public static final String SCHEMA_CUSTOM = "custom";
    public static final String TYPE = "type";
    public static final String REQUIRED = "required";
    private static final String PROPERTIES = "properties";
    public static final List<String> ATTRS_TYPE = Arrays.asList("base", "custom");
    private final Client client;
    private Schema schema;

    public OktaSchemaBuilder(Client client) {
        this.client = client;
    }

    public Schema getSchema() {
        if (this.schema == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    private void buildSchema() {
        SchemaBuilder schemaBld = new SchemaBuilder(OktaConnector.class);
        schemaBld.defineObjectClass(this.build(ObjectClass.ACCOUNT_NAME).addAllAttributeInfo(this.buildAccountAttrInfos()).build());
        schemaBld.defineObjectClass(this.build(ObjectClass.GROUP_NAME).addAllAttributeInfo(this.buildGroupAttrInfos()).build());
        schemaBld.defineObjectClass(this.build(OktaConnector.APPLICATION_NAME).addAllAttributeInfo(this.buildApplicationAttrInfos()).build());
        this.schema = schemaBld.build();
    }

    private ObjectClassInfoBuilder build(String objectClassName) {
        ObjectClassInfoBuilder objClassBld = new ObjectClassInfoBuilder();
        objClassBld.setType(objectClassName);
        objClassBld.setContainer(false);
        return objClassBld;
    }

    private Collection<AttributeInfo> buildAccountAttrInfos() {
        LOG.ok("Retrieve User schema profile", new Object[0]);
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        ExtensibleResource userSchema = (ExtensibleResource)this.client.getDataStore().http().get("/api/v1/meta/schemas/user/default", ExtensibleResource.class);
        Map definitions = (Map)Map.class.cast(userSchema.get((Object)SCHEMA_DEFINITIONS));
        ATTRS_TYPE.stream().forEach(item -> {
            List requiredAttrs = (List)((Map)definitions.get(item)).get(REQUIRED);
            Map schemas = (Map)definitions.get(item);
            ((Map)schemas.get(PROPERTIES)).forEach((key, value) -> {
                AttributeInfoBuilder attributeInfo = new AttributeInfoBuilder();
                attributeInfo.setRequired(requiredAttrs != null && requiredAttrs.contains(key));
                attributeInfos.add(AttributeInfoBuilder.build((String)key, OktaAttribute.getType((String)((Map)value).get(TYPE))));
            });
        });
        AttributeInfoBuilder attributeInfo = new AttributeInfoBuilder();
        attributeInfo.setRequired(true);
        attributeInfos.add(AttributeInfoBuilder.build((String)"id", String.class));
        attributeInfos.add(AttributeInfoBuilder.define((String)"oktaGroups", String.class).setMultiValued(true).setReturnedByDefault(false).build());
        return attributeInfos;
    }

    private Collection<AttributeInfo> buildGroupAttrInfos() {
        LOG.ok("Retrieve Group schema profile", new Object[0]);
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        attributeInfos.add(AttributeInfoBuilder.build((String)"id", String.class));
        attributeInfos.add(AttributeInfoBuilder.build((String)"name", String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        attributeInfos.add(AttributeInfoBuilder.build((String)"description", String.class));
        return attributeInfos;
    }

    private Collection<AttributeInfo> buildApplicationAttrInfos() {
        LOG.ok("Retrieve Application schema profile", new Object[0]);
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        attributeInfos.add(AttributeInfoBuilder.build((String)"id", String.class));
        attributeInfos.add(AttributeInfoBuilder.build((String)"name", String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        attributeInfos.add(AttributeInfoBuilder.build((String)"label", String.class));
        return attributeInfos;
    }
}

