/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta.utils;

import com.okta.sdk.resource.ResourceException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.ConnectorSecurityException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.PermissionDeniedException;
import org.identityconnectors.framework.common.exceptions.RetryableException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;

public class OktaUtils {
    private static final Log LOG = Log.getLog(OktaUtils.class);
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");

    public static void handleGeneralError(String message) {
        LOG.error("General error : {0}", new Object[]{message});
        throw new ConnectorException(message);
    }

    public static void handleGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw new ConnectorException(message, (Throwable)ex);
    }

    public static void wrapGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        if (ex instanceof ResourceException) {
            ex = OktaUtils.wrapResourceException((ResourceException)((Object)ex));
        }
        throw ConnectorException.wrap((Throwable)ex);
    }

    private static Exception wrapResourceException(ResourceException e) {
        switch (e.getStatus()) {
            case 400: {
                if (e.getError().getCode().equals("E0000001")) {
                    boolean isAlreadyExists = e.getError().getCauses().stream().anyMatch(x -> x.getSummary().endsWith("An object with this field already exists in the current organization"));
                    if (isAlreadyExists) {
                        return new AlreadyExistsException((Throwable)e);
                    }
                } else {
                    return new InvalidAttributeValueException((Throwable)e);
                }
            }
            case 401: {
                return new ConnectorSecurityException((Throwable)e);
            }
            case 403: {
                return new PermissionDeniedException((Throwable)e);
            }
            case 404: {
                return new UnknownUidException((Throwable)e);
            }
            case 429: {
                return RetryableException.wrap((String)e.getMessage(), (Throwable)e);
            }
        }
        return e;
    }

    public static String buildSearchQuery(String attributeName, String attributeValue) {
        StringBuilder query = new StringBuilder("profile." + attributeName);
        query.append(" eq ");
        query.append("\"");
        query.append(attributeValue);
        query.append("\"");
        return query.toString();
    }

    public static Date convertToDate(long source) {
        Calendar cal = Calendar.getInstance(UTC_TIMEZONE);
        cal.setTimeInMillis(source);
        return cal.getTime();
    }
}

