/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionListenerUtils;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ProxyConfig;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogic;

public class CachedRowSetResultSetProxyLogic
implements ResultSetProxyLogic {
    private ResultSet resultSet;
    private ResultSet cachedRowSet;
    private ConnectionInfo connectionInfo;
    private ProxyConfig proxyConfig;
    protected boolean supportIsClosedMethod = true;
    protected boolean isClosed;

    public CachedRowSetResultSetProxyLogic(ResultSet resultSet, ResultSet cachedRowSet, ConnectionInfo connectionInfo, ProxyConfig proxyConfig) {
        this.resultSet = resultSet;
        this.cachedRowSet = cachedRowSet;
        this.connectionInfo = connectionInfo;
        this.proxyConfig = proxyConfig;
    }

    @Override
    public Object invoke(Method method, Object[] args) throws Throwable {
        return MethodExecutionListenerUtils.invoke(new MethodExecutionListenerUtils.MethodExecutionCallback(){

            @Override
            public Object execute(Object proxyTarget, Method method, Object[] args) throws Throwable {
                return CachedRowSetResultSetProxyLogic.this.performQueryExecutionListener(method, args);
            }
        }, this.proxyConfig, this.cachedRowSet, this.connectionInfo, method, args);
    }

    private Object performQueryExecutionListener(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.resultSet.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.resultSet.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("hashCode".equals(methodName)) {
            return this.resultSet.hashCode();
        }
        if ("equals".equals(methodName)) {
            return this.resultSet.equals(args[0]);
        }
        if ("close".equals(methodName)) {
            this.isClosed = true;
        } else if ("getTarget".equals(methodName)) {
            return this.resultSet;
        }
        if (this.supportIsClosedMethod && "isClosed".equals(methodName)) {
            return this.isClosed;
        }
        try {
            return MethodUtils.proceedExecution(method, this.cachedRowSet, args);
        }
        catch (Throwable throwable) {
            if (throwable instanceof SQLException) {
                throw throwable;
            }
            String reason = String.format("CachedRowSet threw exception: %s", throwable);
            throw new SQLException(reason, throwable);
        }
    }
}

