/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.boot.autoconfigure;

import java.util.HashSet;
import java.util.Set;
import net.ttddyy.observation.tracing.JdbcObservationDocumentation;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="jdbc")
public class JdbcProperties {
    private Set<TraceType> includes = Set.of(TraceType.CONNECTION, TraceType.QUERY, TraceType.FETCH, TraceType.KEYS);
    private Set<String> excludedDataSourceBeanNames = new HashSet<String>();
    private DataSourceProxy datasourceProxy = new DataSourceProxy();
    private Event event = new Event();
    private ResultsetOperations resultsetOperations = new ResultsetOperations();

    public Set<TraceType> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<TraceType> includes) {
        this.includes = includes;
    }

    public Set<String> getExcludedDataSourceBeanNames() {
        return this.excludedDataSourceBeanNames;
    }

    public void setExcludedDataSourceBeanNames(Set<String> excludedDataSourceBeanNames) {
        this.excludedDataSourceBeanNames = excludedDataSourceBeanNames;
    }

    public DataSourceProxy getDatasourceProxy() {
        return this.datasourceProxy;
    }

    public void setDatasourceProxy(DataSourceProxy datasourceProxy) {
        this.datasourceProxy = datasourceProxy;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public ResultsetOperations getResultsetOperations() {
        return this.resultsetOperations;
    }

    public void setResultsetOperations(ResultsetOperations resultsetOperations) {
        this.resultsetOperations = resultsetOperations;
    }

    public static enum TraceType {
        CONNECTION(JdbcObservationDocumentation.CONNECTION),
        QUERY(JdbcObservationDocumentation.QUERY),
        FETCH(JdbcObservationDocumentation.RESULT_SET),
        KEYS(JdbcObservationDocumentation.GENERATED_KEYS);

        final JdbcObservationDocumentation supportedDocumentation;

        private TraceType(JdbcObservationDocumentation supportedDocumentation) {
            this.supportedDocumentation = supportedDocumentation;
        }
    }

    public static class DataSourceProxy {
        private Logging logging = Logging.SLF4J;
        private Query query = new Query();
        private SlowQuery slowQuery = new SlowQuery();
        private boolean multiline = true;
        private boolean includeParameterValues;
        private boolean jsonFormat = false;
        private DataSourceType type = DataSourceType.PROXY;

        public Logging getLogging() {
            return this.logging;
        }

        public void setLogging(Logging logging) {
            this.logging = logging;
        }

        public Query getQuery() {
            return this.query;
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public SlowQuery getSlowQuery() {
            return this.slowQuery;
        }

        public void setSlowQuery(SlowQuery slowQuery) {
            this.slowQuery = slowQuery;
        }

        public boolean isMultiline() {
            return this.multiline;
        }

        public void setMultiline(boolean multiline) {
            this.multiline = multiline;
        }

        public boolean isJsonFormat() {
            return this.jsonFormat;
        }

        public void setJsonFormat(boolean jsonFormat) {
            this.jsonFormat = jsonFormat;
        }

        public boolean isIncludeParameterValues() {
            return this.includeParameterValues;
        }

        public void setIncludeParameterValues(boolean includeParameterValues) {
            this.includeParameterValues = includeParameterValues;
        }

        public DataSourceType getType() {
            return this.type;
        }

        public void setType(DataSourceType type) {
            this.type = type;
        }
    }

    public static class Event {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class ResultsetOperations {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static enum DataSourceType {
        PROXY,
        CONCRETE;

    }

    public static enum Logging {
        SYSOUT,
        SLF4J,
        COMMONS,
        JUL,
        LOG4J;

    }

    public static class SlowQuery {
        private boolean enableLogging = false;
        private String loggerName;
        private String logLevel = "WARN";
        private long threshold = 300L;

        public boolean isEnableLogging() {
            return this.enableLogging;
        }

        public void setEnableLogging(boolean enableLogging) {
            this.enableLogging = enableLogging;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public long getThreshold() {
            return this.threshold;
        }

        public void setThreshold(long threshold) {
            this.threshold = threshold;
        }
    }

    public static class Query {
        private boolean enableLogging = false;
        private String loggerName;
        private String logLevel = "DEBUG";

        public boolean isEnableLogging() {
            return this.enableLogging;
        }

        public void setEnableLogging(boolean enableLogging) {
            this.enableLogging = enableLogging;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }
    }
}

