/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.tracing;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import java.util.Collections;
import java.util.List;
import net.ttddyy.observation.tracing.DataSourceBaseContext;

public abstract class DataSourceBaseObservationHandler
extends PropagatingSenderTracingObservationHandler<DataSourceBaseContext> {
    private static final NoopPropagator NOOP_PROPAGATOR = new NoopPropagator();

    public DataSourceBaseObservationHandler(Tracer tracer) {
        super(tracer, (Propagator)NOOP_PROPAGATOR);
    }

    public void customizeSenderSpan(DataSourceBaseContext context, Span span) {
        if (context.getHost() != null) {
            span.remoteIpAndPort(context.getHost(), context.getPort());
        }
    }

    static class NoopPropagator
    implements Propagator {
        NoopPropagator() {
        }

        public List<String> fields() {
            return Collections.emptyList();
        }

        public <C> void inject(TraceContext context, C carrier, Propagator.Setter<C> setter) {
        }

        public <C> Span.Builder extract(C carrier, Propagator.Getter<C> getter) {
            throw new UnsupportedOperationException();
        }
    }
}

