/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.basicimpl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.wimpi.pim.contact.model.Image;
import net.wimpi.pim.contact.model.Key;
import net.wimpi.pim.contact.model.Sound;

public class DataContainer
implements Key,
Sound,
Image {
    static final long serialVersionUID = -114960534115119898L;
    protected String m_Uri;
    protected String m_ContentType;
    protected byte[] m_Data = null;
    protected boolean m_isUri;

    public boolean isData() {
        return !this.m_isUri;
    }

    public String getContentType() {
        return this.m_ContentType;
    }

    public void setContentType(String ctype) {
        this.m_ContentType = ctype;
    }

    public void setData(byte[] data) {
        this.m_Data = data;
        this.m_isUri = false;
    }

    public void setData(String uri) throws IOException, MalformedURLException {
        InputStream in = new URL(uri).openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int amount = 0;
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
        this.setData(out.toByteArray());
    }

    public byte[] getData() {
        return this.m_Data;
    }

    public String getURI() {
        return this.m_Uri;
    }

    public void setURI(String uri) {
        this.m_Uri = uri;
        this.m_isUri = true;
    }

    public boolean isURI() {
        return this.m_isUri;
    }

    public InputStream getInputStream() throws IOException, MalformedURLException {
        if (!this.m_isUri) {
            return new ByteArrayInputStream(this.m_Data);
        }
        return new URL(this.m_Uri).openStream();
    }

    public byte[] getDataFromURI() throws IOException, MalformedURLException {
        InputStream in = this.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int amount = 0;
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
        return out.toByteArray();
    }
}

