/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.basicimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.wimpi.pim.contact.model.Extension;
import net.wimpi.pim.contact.model.Extensions;

public class ExtensionsImpl
implements Extensions {
    static final long serialVersionUID = -2386296030270876018L;
    protected Map m_Extensions = Collections.synchronizedMap(new HashMap(10));
    private static Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public String[] listIdentifiers() {
        Set keys = this.m_Extensions.keySet();
        String[] strs = new String[keys.size()];
        return keys.toArray(strs);
    }

    public Extension[] list(String xidentifier) {
        if (this.m_Extensions.containsKey(xidentifier)) {
            return (Extension[])((List)this.m_Extensions.get(xidentifier)).toArray();
        }
        return new Extension[0];
    }

    public Iterator iterator(String xidentifier) {
        if (this.m_Extensions.containsKey(xidentifier)) {
            return ((List)this.m_Extensions.get(xidentifier)).iterator();
        }
        return EMPTY_ITERATOR;
    }

    public Extension get(String xidentifier) {
        if (this.m_Extensions.containsKey(xidentifier)) {
            return (Extension)((List)this.m_Extensions.get(xidentifier)).get(0);
        }
        return null;
    }

    public Extension get(String xidentifier, int idx) throws IndexOutOfBoundsException {
        if (this.m_Extensions.containsKey(xidentifier)) {
            return (Extension)((List)this.m_Extensions.get(xidentifier)).get(idx);
        }
        return null;
    }

    public void add(Extension ext) {
        String xidentifier = ext.getIdentifier();
        if (this.m_Extensions.containsKey(xidentifier)) {
            ((List)this.m_Extensions.get(xidentifier)).add(ext);
        } else {
            List<Extension> list = Collections.synchronizedList(new ArrayList(5));
            list.add(ext);
            this.m_Extensions.put(xidentifier, list);
        }
    }

    public void remove(Extension ext) {
        String xidentifier = ext.getIdentifier();
        if (this.m_Extensions.containsKey(xidentifier)) {
            ((List)this.m_Extensions.get(xidentifier)).remove(ext);
        }
    }

    public void remove(String xidentifier) {
        this.m_Extensions.remove(xidentifier);
    }

    public Extension remove(String xidentifier, int idx) throws IndexOutOfBoundsException {
        if (this.m_Extensions.containsKey(xidentifier)) {
            return (Extension)((List)this.m_Extensions.get(xidentifier)).remove(idx);
        }
        return null;
    }

    public int size() {
        int count = 0;
        Iterator iterator = this.m_Extensions.keySet().iterator();
        while (iterator.hasNext()) {
            count += this.size(iterator.next().toString());
        }
        return count;
    }

    public int size(String xidentifier) {
        if (this.m_Extensions.containsKey(xidentifier)) {
            return ((List)this.m_Extensions.get(xidentifier)).size();
        }
        return 0;
    }
}

