/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class BDAYItemHandler
implements ItemHandler {
    private DateFormat m_SimpleDateFormat = new SimpleDateFormat("yyyyMMdd");
    private DateFormat m_ExtendedDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public void handleItem(Contact ct, versitItem item) {
        String datestr = item.getDecodedValue();
        Date bday = null;
        datestr = StringUtil.split(datestr, "T")[0];
        try {
            bday = datestr.indexOf("-") == -1 ? this.m_SimpleDateFormat.parse(datestr) : this.m_ExtendedDateFormat.parse(datestr);
        }
        catch (ParseException pex) {
            // empty catch block
        }
        PersonalIdentity pid = ct.getPersonalIdentity();
        if (pid == null) {
            pid = Pim.getContactModelFactory().createPersonalIdentity();
            ct.setPersonalIdentity(pid);
        }
        pid.setBirthDate(bday);
    }

    public versitItem[] createItems(Contact ct) {
        PersonalIdentity pid = ct.getPersonalIdentity();
        if (pid == null) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        Date bday = pid.getBirthDate();
        if (bday == null) {
            return new versitItem[0];
        }
        versitItem item = new versitItem("BDAY");
        item.setValue(this.m_ExtendedDateFormat.format(bday));
        items[0] = item;
        return items;
    }
}

