/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class NICKNAMEItemHandler
implements ItemHandler {
    NICKNAMEItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        PersonalIdentity pid = ct.getPersonalIdentity();
        if (pid == null) {
            pid = Pim.getContactModelFactory().createPersonalIdentity();
            ct.setPersonalIdentity(pid);
        }
        String[] multi = StringUtil.split(item.getDecodedValue(), ",");
        for (int n = 0; n < multi.length; ++n) {
            pid.addNickname(multi[n]);
        }
    }

    public versitItem[] createItems(Contact ct) {
        if (!ct.hasPersonalIdentity()) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        String[] nicknames = ct.getPersonalIdentity().listNicknames();
        if (StringUtil.isValidStringArray(nicknames)) {
            versitItem item = new versitItem("NICKNAME");
            item.setValue(StringUtil.joinList(nicknames));
            items[0] = item;
            return items;
        }
        return new versitItem[0];
    }
}

