/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Organization;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class ORGItemHandler
implements ItemHandler {
    ORGItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        Organization org;
        OrganizationalIdentity orgid = ct.getOrganizationalIdentity();
        if (orgid == null) {
            orgid = Pim.getContactModelFactory().createOrganizationalIdentity();
            ct.setOrganizationalIdentity(orgid);
        }
        if ((org = orgid.getOrganization()) == null) {
            org = Pim.getContactModelFactory().createOrganization();
            orgid.setOrganization(org);
        }
        String[] components = StringUtil.split(item.getDecodedValue(), ";");
        block3: for (int i = 0; i < components.length; ++i) {
            switch (i) {
                case 0: {
                    org.setName(components[0]);
                    continue block3;
                }
                default: {
                    if (components[i].length() <= 0) continue block3;
                    org.addUnit(components[i]);
                }
            }
        }
    }

    public versitItem[] createItems(Contact ct) {
        OrganizationalIdentity orgid = ct.getOrganizationalIdentity();
        if (orgid == null) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        Organization org = orgid.getOrganization();
        if (org == null) {
            return new versitItem[0];
        }
        String name = org.getName();
        String[] units = org.listUnits();
        if (!StringUtil.isValidString(name)) {
            return new versitItem[0];
        }
        versitItem item = new versitItem("ORG");
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(org.getName()).append(";");
        if (StringUtil.isValidStringArray(units)) {
            for (int i = 0; i < units.length; ++i) {
                sbuf.append(units[i]);
                if (i >= units.length - 1) continue;
                sbuf.append(";");
            }
        } else {
            sbuf.append(";");
        }
        item.setValue(sbuf.toString());
        items[0] = item;
        return items;
    }
}

