/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Organization;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class XORGURLItemHandler
implements ItemHandler {
    XORGURLItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        Organization org;
        OrganizationalIdentity orgid = ct.getOrganizationalIdentity();
        if (orgid == null) {
            orgid = Pim.getContactModelFactory().createOrganizationalIdentity();
            ct.setOrganizationalIdentity(orgid);
        }
        if ((org = orgid.getOrganization()) == null) {
            org = Pim.getContactModelFactory().createOrganization();
            orgid.setOrganization(org);
        }
        org.setURL(item.getDecodedValue());
    }

    public versitItem[] createItems(Contact ct) throws IndexOutOfBoundsException {
        OrganizationalIdentity orgid = ct.getOrganizationalIdentity();
        if (orgid == null) {
            return new versitItem[0];
        }
        Organization org = orgid.getOrganization();
        if (org == null) {
            return new versitItem[0];
        }
        String url = org.getURL();
        if (StringUtil.isValidString(url)) {
            versitItem[] items = new versitItem[]{new versitItem("X-ORG-URL", url)};
            return items;
        }
        return new versitItem[0];
    }
}

