/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.util.versitio;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitException;

public class versitItem {
    private String m_Identifier;
    private String m_Group;
    private String m_unprocessedParameters;
    private String m_Value;
    private HashMap m_Params;

    public versitItem(String token) {
        this.m_Params = new HashMap();
        this.setIdentifier(token);
    }

    public versitItem(String token, String value) {
        this.m_Params = new HashMap();
        this.setIdentifier(token);
        this.setValue(value);
    }

    private versitItem() {
    }

    public void setIdentifier(String id) {
        this.m_Identifier = id;
    }

    public String getIdentifier() {
        return this.m_Identifier;
    }

    public String getGroup() {
        return this.m_Group;
    }

    public void setGroup(String group) {
        this.m_Group = group;
    }

    public boolean hasGroup() {
        return this.m_Group != null;
    }

    protected void setUnprocessedParameters(String params) {
        this.m_unprocessedParameters = params;
    }

    public String getUnprocessedParameters() {
        return this.m_unprocessedParameters;
    }

    public String[] getParameter(String name) {
        if (this.m_Params != null) {
            Object o = this.m_Params.get(name);
            if (o instanceof String) {
                String[] retval = new String[]{(String)o};
                return retval;
            }
            return (String[])o;
        }
        return null;
    }

    public Map getParameters() {
        return this.m_Params;
    }

    public boolean hasParameters() {
        return this.m_Params != null;
    }

    public void addParameter(String name, String value) {
        String[] values;
        if (this.m_Params.containsKey(name)) {
            String[] oldValues = (String[])this.m_Params.get(name);
            values = new String[oldValues.length + 1];
            for (int i = 0; i < oldValues.length; ++i) {
                values[i] = oldValues[i];
            }
            values[oldValues.length] = value;
        } else {
            values = new String[]{value};
        }
        this.m_Params.put(name, values);
    }

    public void setValue(String value) {
        this.m_Value = value;
    }

    public String getValue() {
        return this.m_Value;
    }

    public String getDecodedValue() {
        String[] params = this.getParameter("ENCODING");
        if (params != null && params.length > 0) {
            if ("QUOTED-PRINTABLE".equals(params[0])) {
                return EncodingUtility.decodeQP(this.m_Value);
            }
            if ("BASE64".equals(params[0])) {
                return new String(EncodingUtility.decodeBase64(EncodingUtility.removeWhiteSpace(this.getValue().getBytes())));
            }
            return this.m_Value;
        }
        return this.m_Value;
    }

    private void setGroupAndId(String str) {
        int splitpos = str.indexOf(46);
        if (splitpos != -1) {
            this.m_Group = str.substring(0, splitpos);
            this.m_Identifier = str.substring(splitpos + 1, str.length());
        } else {
            this.m_Identifier = str.toUpperCase();
        }
    }

    private void processParameters() {
        String[] params = StringUtil.split(this.getUnprocessedParameters(), ";");
        this.m_Params = new HashMap((int)((double)params.length * 1.35));
        String[] keyvalue = null;
        String[] paramlist = null;
        for (int i = 0; i < params.length; ++i) {
            keyvalue = StringUtil.split(params[i], "=");
            if (keyvalue.length == 1) {
                this.addParameter("default".toUpperCase(), keyvalue[0]);
                continue;
            }
            paramlist = StringUtil.splitList(keyvalue[1]);
            if (paramlist.length == 1) {
                this.addParameter(keyvalue[0].toUpperCase(), keyvalue[1]);
                continue;
            }
            for (int n = 0; n < paramlist.length; ++n) {
                this.addParameter(keyvalue[0].toUpperCase(), paramlist[n]);
            }
        }
    }

    public static versitItem createItem(String line) throws versitException {
        versitItem item = new versitItem();
        String prefix = "";
        int splitpos = line.indexOf(58);
        if (splitpos != -1) {
            prefix = line.substring(0, splitpos);
            item.setValue(line.substring(splitpos + 1, line.length()));
            splitpos = prefix.indexOf(59);
            if (splitpos != -1) {
                item.setGroupAndId(prefix.substring(0, splitpos));
                item.setUnprocessedParameters(prefix.substring(splitpos + 1, prefix.length()));
                item.processParameters();
            } else {
                item.setGroupAndId(prefix);
            }
        } else {
            throw new versitException("versit format seems invalid.");
        }
        return item;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.m_Group != null && this.m_Group.length() > 0) {
            sbuf.append(this.m_Group).append(".");
        }
        sbuf.append(this.m_Identifier);
        Set keys = this.m_Params.keySet();
        int i = 0;
        if (keys.size() > 0) {
            sbuf.append(";");
        }
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String[] params = this.getParameter(key);
            if (params != null) {
                sbuf.append(key).append("=").append(StringUtil.joinList(params));
                if (iter.hasNext()) {
                    sbuf.append(";");
                }
            }
            ++i;
        }
        sbuf.append(":");
        sbuf.append(this.fold(sbuf.length(), this.m_Value));
        return sbuf.toString();
    }

    private String fold(int start, String str) {
        StringBuffer sbuf = new StringBuffer();
        if (start + str.length() > 75) {
            int breakcounter = start;
            for (int counter = 0; counter < str.length(); ++counter) {
                sbuf.append(str.charAt(counter));
                if (++breakcounter != 75) continue;
                breakcounter = 0;
                sbuf.append("\r\n\t");
            }
            return sbuf.toString();
        }
        return str;
    }
}

