/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.util.versitio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.wimpi.pim.util.versitio.versitException;
import net.wimpi.pim.util.versitio.versitInputStream;
import net.wimpi.pim.util.versitio.versitItem;

public class versitParser {
    private versitInputStream m_Input;
    private List m_Items;
    private List m_CardObjects;
    private List m_CalObjects;
    private boolean m_Validating = true;

    public versitParser(InputStream in) {
        this.m_Input = new versitInputStream(in);
        this.m_Items = Collections.synchronizedList(new ArrayList(35));
    }

    public versitParser(InputStream in, String enc) throws UnsupportedEncodingException {
        this.m_Input = new versitInputStream(in, enc);
        this.m_Items = Collections.synchronizedList(new ArrayList(35));
    }

    public void parse() throws versitException {
        try {
            while (this.m_Input.hasLine()) {
                String line = this.m_Input.readLine();
                if (line == null || line.length() <= 0) continue;
                this.m_Items.add(versitItem.createItem(line));
            }
            this.bundleObjects();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isValidating() {
        return this.m_Validating;
    }

    public void setValidating(boolean b) {
        this.m_Validating = true;
    }

    private void bundleObjects() throws versitException {
        this.m_CardObjects = new ArrayList(3);
        this.m_CalObjects = new ArrayList(3);
        List itembundle = null;
        versitItem item = null;
        int pos = 0;
        ListIterator iter = this.m_Items.listIterator();
        while (iter.hasNext()) {
            item = (versitItem)iter.next();
            if (item.getIdentifier().equalsIgnoreCase("BEGIN")) {
                int endpos;
                if (item.getValue().equalsIgnoreCase("VCARD")) {
                    endpos = this.findObjectEnd("VCARD", iter, pos);
                    itembundle = this.m_Items.subList(pos + 1, endpos);
                    pos = endpos;
                    if (this.isValidating()) {
                        this.validateCard(itembundle);
                    }
                    this.m_CardObjects.add(itembundle);
                } else if (item.getValue().equalsIgnoreCase("VCALENDAR")) {
                    endpos = this.findObjectEnd("VCALENDAR", iter, pos);
                    itembundle = this.m_Items.subList(pos + 1, endpos);
                    pos = endpos;
                    this.m_CalObjects.add(itembundle);
                }
            }
            ++pos;
        }
    }

    public List getCardObjects() {
        return this.m_CardObjects;
    }

    public List getCalendarObjects() {
        return this.m_CalObjects;
    }

    private int findObjectEnd(String objecttype, Iterator iter, int pos) throws versitException {
        boolean done = false;
        versitItem item = null;
        while (iter.hasNext() || !done) {
            ++pos;
            item = (versitItem)iter.next();
            if (!item.getIdentifier().equalsIgnoreCase("END") || !item.getValue().equalsIgnoreCase(objecttype)) continue;
            return pos;
        }
        if (!done) {
            throw new versitException("Object end token missing.");
        }
        return pos;
    }

    private void validateCard(List items) throws versitException {
        String version = this.getVersion(items);
        if (version.equals("2.1")) {
            String[] mandatoryTokens = new String[]{"N"};
            if (!this.hasMandatoryTokens(items, mandatoryTokens)) {
                throw new versitException("Mandatory tokens missing.");
            }
        } else if (version.equals("3.0")) {
            String[] mandatoryTokens = new String[]{"N", "FN"};
            if (!this.hasMandatoryTokens(items, mandatoryTokens)) {
                throw new versitException("Mandatory tokens missing.");
            }
        } else {
            throw new versitException("Factory cannot handle format version " + version + ".");
        }
    }

    private String getVersion(List items) throws versitException {
        versitItem item = null;
        ListIterator iter = items.listIterator();
        while (iter.hasNext()) {
            item = (versitItem)iter.next();
            if (!item.getIdentifier().equalsIgnoreCase("VERSION")) continue;
            return item.getValue();
        }
        throw new versitException("vCard invalid: the version property is mandatory.");
    }

    private boolean hasMandatoryTokens(List items, String[] tokens) {
        versitItem item = null;
        int count = 0;
        ListIterator iter = items.listIterator();
        while (iter.hasNext()) {
            item = (versitItem)iter.next();
            for (int i = 0; i < tokens.length; ++i) {
                if (!item.getIdentifier().equalsIgnoreCase(tokens[i])) continue;
                ++count;
            }
        }
        return count == tokens.length;
    }

    public static void main(String[] args) {
        try {
            File infile = new File(args[0]);
            FileInputStream fin = new FileInputStream(infile);
            versitParser parser = new versitParser(fin);
            parser.parse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

