/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzer;
import nl.basjes.parse.useragent.clienthints.ClientHints;

public interface CHParser
extends Serializable {
    public static final Pattern SF_STRING_PATTERN = Pattern.compile("^\"(.*)\"$");

    @Nonnull
    public ClientHints parse(@Nonnull Map<String, String> var1, @Nonnull ClientHints var2, @Nonnull String var3);

    @Nonnull
    public String inputField();

    default public Boolean parseBoolean(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "?0": {
                return Boolean.FALSE;
            }
            case "?1": {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    default public String parseSfString(String value) {
        if (value == null) {
            return null;
        }
        Matcher matcher = SF_STRING_PATTERN.matcher(value);
        if (matcher.find()) {
            String result = matcher.group(1).trim();
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        return null;
    }

    default public ArrayList<String> parseSfList(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.stream(value.split(",")).map(String::trim).map(this::parseSfString).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    default public void initializeCache(@Nonnull AbstractUserAgentAnalyzer.ClientHintsCacheInstantiator<?> clientHintsCacheInstantiator, int cacheSize) {
    }

    default public void clearCache() {
    }
}

