/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcBroadcastEvent;
import org.acplt.oncrpc.OncRpcBroadcastListener;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.OncRpcUdpSocketHelper;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrUdpDecodingStream;
import org.acplt.oncrpc.XdrUdpEncodingStream;

public class OncRpcUdpClient
extends OncRpcClient {
    private DatagramSocket socket;
    private OncRpcUdpSocketHelper socketHelper;
    protected XdrUdpEncodingStream sendingXdr;
    protected XdrUdpDecodingStream receivingXdr;
    protected int retransmissionTimeout;
    protected int retransmissionMode;

    public OncRpcUdpClient(InetAddress host, int program, int version, int port) throws OncRpcException, IOException {
        this(host, program, version, port, 8192);
    }

    public OncRpcUdpClient(InetAddress host, int program, int version, int port, int bufferSize) throws OncRpcException, IOException {
        super(host, program, version, port, 17);
        this.retransmissionTimeout = this.timeout;
        this.retransmissionMode = 1;
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.socket = new DatagramSocket();
        this.socketHelper = new OncRpcUdpSocketHelper(this.socket);
        if (this.socketHelper.getSendBufferSize() < bufferSize) {
            this.socketHelper.setSendBufferSize(bufferSize);
        }
        if (this.socketHelper.getReceiveBufferSize() < bufferSize) {
            this.socketHelper.setReceiveBufferSize(bufferSize);
        }
        this.sendingXdr = new XdrUdpEncodingStream(this.socket, bufferSize);
        this.receivingXdr = new XdrUdpDecodingStream(this.socket, bufferSize);
    }

    public void close() throws OncRpcException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    public synchronized void call(int procedureNumber, int versionNumber, XdrAble params, XdrAble result) throws OncRpcException {
        block16: for (int refreshesLeft = 1; refreshesLeft >= 0; --refreshesLeft) {
            this.nextXid();
            OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, versionNumber, procedureNumber, this.auth);
            OncRpcClientReplyMessage replyHeader = new OncRpcClientReplyMessage(this.auth);
            long stopTime = System.currentTimeMillis() + (long)this.timeout;
            int resendTimeout = this.retransmissionTimeout;
            do {
                try {
                    this.sendingXdr.beginEncoding(this.host, this.port);
                    callHeader.xdrEncode(this.sendingXdr);
                    params.xdrEncode(this.sendingXdr);
                    this.sendingXdr.endEncoding();
                }
                catch (IOException e) {
                    throw new OncRpcException(3, e.getLocalizedMessage());
                }
                if (this.timeout == 0) {
                    return;
                }
                while (true) {
                    block24: {
                        try {
                            int currentTimeout = (int)(stopTime - System.currentTimeMillis());
                            if (currentTimeout > resendTimeout) {
                                currentTimeout = resendTimeout;
                            } else if (currentTimeout < 1) {
                                currentTimeout = 1;
                            }
                            this.socket.setSoTimeout(currentTimeout);
                            this.receivingXdr.beginDecoding();
                            try {
                                replyHeader.xdrDecode(this.receivingXdr);
                            }
                            catch (OncRpcException e) {
                                this.receivingXdr.endDecoding();
                                throw e;
                            }
                            if (replyHeader.messageId != callHeader.messageId) break block24;
                            if (!replyHeader.successfullyAccepted()) {
                                this.receivingXdr.endDecoding();
                                if (refreshesLeft > 0 && replyHeader.replyStatus == 1 && replyHeader.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue block16;
                                throw replyHeader.newException();
                            }
                            try {
                                result.xdrDecode(this.receivingXdr);
                            }
                            catch (OncRpcException e) {
                                this.receivingXdr.endDecoding();
                                throw e;
                            }
                            this.receivingXdr.endDecoding();
                            return;
                        }
                        catch (InterruptedIOException e) {
                            break;
                        }
                        catch (IOException e) {
                            try {
                                this.receivingXdr.endDecoding();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                            throw new OncRpcException(4, e.getLocalizedMessage());
                        }
                        catch (OncRpcException e) {
                            try {
                                this.receivingXdr.endDecoding();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                            if (e.getReason() == 44) break block24;
                            throw e;
                        }
                    }
                    try {
                        this.receivingXdr.endDecoding();
                    }
                    catch (IOException e) {
                        throw new OncRpcException(4, e.getLocalizedMessage());
                    }
                }
                if (this.retransmissionMode != 0) continue;
                resendTimeout *= 2;
            } while (System.currentTimeMillis() < stopTime);
            throw new OncRpcTimeoutException();
        }
    }

    public synchronized void broadcastCall(int procedureNumber, XdrAble params, XdrAble result, OncRpcBroadcastListener listener) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, this.version, procedureNumber, this.auth);
        OncRpcClientReplyMessage replyHeader = new OncRpcClientReplyMessage(this.auth);
        try {
            this.sendingXdr.beginEncoding(this.host, this.port);
            callHeader.xdrEncode(this.sendingXdr);
            params.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding();
        }
        catch (IOException e) {
            throw new OncRpcException(3, e.getLocalizedMessage());
        }
        long stopTime = System.currentTimeMillis() + (long)this.timeout;
        do {
            try {
                int currentTimeout = (int)(stopTime - System.currentTimeMillis());
                if (currentTimeout < 0) {
                    currentTimeout = 0;
                }
                this.socket.setSoTimeout(currentTimeout);
                this.receivingXdr.beginDecoding();
                replyHeader.xdrDecode(this.receivingXdr);
                if (replyHeader.messageId == callHeader.messageId) {
                    if (!replyHeader.successfullyAccepted()) {
                        this.receivingXdr.endDecoding();
                    }
                    result.xdrDecode(this.receivingXdr);
                    if (listener != null) {
                        OncRpcBroadcastEvent evt = new OncRpcBroadcastEvent(this, this.receivingXdr.getSenderAddress(), procedureNumber, params, result);
                        listener.replyReceived(evt);
                    }
                    this.receivingXdr.endDecoding();
                    continue;
                }
                try {
                    this.receivingXdr.endDecoding();
                }
                catch (IOException e) {
                    throw new OncRpcException(4, e.getLocalizedMessage());
                }
            }
            catch (InterruptedIOException e) {
            }
            catch (IOException e) {
                throw new OncRpcException(4, e.getLocalizedMessage());
            }
        } while (System.currentTimeMillis() < stopTime);
    }

    public void setRetransmissionMode(int mode) {
        this.retransmissionMode = mode;
    }

    public int getRetransmissionMode() {
        return this.retransmissionMode;
    }

    public void setRetransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("timeouts must be positive.");
        }
        this.retransmissionTimeout = milliseconds;
    }

    public int getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.receivingXdr.setCharacterEncoding(characterEncoding);
        this.sendingXdr.setCharacterEncoding(characterEncoding);
    }

    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }
}

