/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.delegate.event.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitiEventSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ActivitiEventSupport.class);
    protected List<ActivitiEventListener> eventListeners = new CopyOnWriteArrayList<ActivitiEventListener>();
    protected Map<ActivitiEventType, List<ActivitiEventListener>> typedListeners = new HashMap<ActivitiEventType, List<ActivitiEventListener>>();

    public synchronized void addEventListener(ActivitiEventListener listenerToAdd) {
        if (listenerToAdd == null) {
            throw new ActivitiIllegalArgumentException("Listener cannot be null.");
        }
        if (!this.eventListeners.contains(listenerToAdd)) {
            this.eventListeners.add(listenerToAdd);
        }
    }

    public synchronized void addEventListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        if (listenerToAdd == null) {
            throw new ActivitiIllegalArgumentException("Listener cannot be null.");
        }
        if (types == null || types.length == 0) {
            this.addEventListener(listenerToAdd);
        } else {
            for (ActivitiEventType type : types) {
                this.addTypedEventListener(listenerToAdd, type);
            }
        }
    }

    public void removeEventListener(ActivitiEventListener listenerToRemove) {
        this.eventListeners.remove(listenerToRemove);
        for (List<ActivitiEventListener> listeners : this.typedListeners.values()) {
            listeners.remove(listenerToRemove);
        }
    }

    public void dispatchEvent(ActivitiEvent event) {
        List<ActivitiEventListener> typed;
        if (event == null) {
            throw new ActivitiIllegalArgumentException("Event cannot be null.");
        }
        if (event.getType() == null) {
            throw new ActivitiIllegalArgumentException("Event type cannot be null.");
        }
        if (!this.eventListeners.isEmpty()) {
            for (ActivitiEventListener listener : this.eventListeners) {
                this.dispatchEvent(event, listener);
            }
        }
        if ((typed = this.typedListeners.get((Object)event.getType())) != null && !typed.isEmpty()) {
            for (ActivitiEventListener listener : typed) {
                this.dispatchEvent(event, listener);
            }
        }
    }

    protected void dispatchEvent(ActivitiEvent event, ActivitiEventListener listener) {
        try {
            listener.onEvent(event);
        }
        catch (Throwable t) {
            if (listener.isFailOnException()) {
                throw new ActivitiException("Exception while executing event-listener", t);
            }
            LOG.warn("Exception while executing event-listener, which was ignored", t);
        }
    }

    protected synchronized void addTypedEventListener(ActivitiEventListener listener, ActivitiEventType type) {
        List<ActivitiEventListener> listeners = this.typedListeners.get((Object)type);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<ActivitiEventListener>();
            this.typedListeners.put(type, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }
}

