/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.calendar;

import java.util.Date;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.calendar.BusinessCalendarImpl;
import org.activiti.engine.runtime.ClockReader;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class DueDateBusinessCalendar
extends BusinessCalendarImpl {
    public static final String NAME = "dueDate";

    public DueDateBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    @Override
    public Date resolveDuedate(String duedate, int maxIterations) {
        try {
            if (duedate.startsWith("P")) {
                return new DateTime((Object)this.clockReader.getCurrentTime()).plus((ReadablePeriod)Period.parse((String)duedate)).toDate();
            }
            return DateTime.parse((String)duedate).toDate();
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't resolve duedate: " + e.getMessage(), e);
        }
    }
}

